/*
 * Decompiled with CFR 0.152.
 */
package loci.common;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import loci.common.IRandomAccess;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.common.StreamHandle;

public class ZipHandle
extends StreamHandle {
    private RandomAccessInputStream in;
    private ZipInputStream zip;
    private String entryName;
    private int entryCount;

    public ZipHandle(String file2) throws IOException {
        ZipEntry ze;
        this.file = file2;
        this.in = ZipHandle.openStream(file2);
        this.zip = new ZipInputStream(this.in);
        this.entryName = null;
        this.entryCount = 0;
        String innerFile = file2.substring(0, file2.length() - 4);
        int slash = innerFile.lastIndexOf(File.separator);
        if (slash < 0) {
            slash = innerFile.lastIndexOf("/");
        }
        if (slash >= 0) {
            innerFile = innerFile.substring(slash + 1);
        }
        boolean matchFound = false;
        while ((ze = this.zip.getNextEntry()) != null) {
            if (this.entryName == null) {
                this.entryName = ze.getName();
            }
            if (!matchFound && ze.getName().startsWith(innerFile)) {
                this.entryName = ze.getName();
                matchFound = true;
            }
            ++this.entryCount;
        }
        this.resetStream();
        this.populateLength();
    }

    public ZipHandle(String file2, ZipEntry entry) throws IOException {
        this.file = file2;
        this.in = ZipHandle.openStream(file2);
        this.zip = new ZipInputStream(this.in);
        this.entryName = entry.getName();
        this.entryCount = 1;
        this.seekToEntry();
        this.resetStream();
        this.populateLength();
    }

    public static boolean isZipFile(String file2) throws IOException {
        if (!file2.toLowerCase().endsWith(".zip")) {
            return false;
        }
        IRandomAccess handle = ZipHandle.getHandle(file2);
        byte[] b = new byte[2];
        if (handle.length() >= 2L) {
            handle.read(b);
        }
        handle.close();
        return new String(b, "UTF-8").equals("PK");
    }

    public String getEntryName() {
        return this.entryName;
    }

    public DataInputStream getInputStream() {
        return this.stream;
    }

    public int getEntryCount() {
        return this.entryCount;
    }

    public void close() throws IOException {
        if (!Location.getIdMap().containsValue(this)) {
            super.close();
            this.zip = null;
            this.entryName = null;
            if (this.in != null) {
                this.in.close();
            }
            this.in = null;
            this.entryCount = 0;
        }
    }

    protected void resetStream() throws IOException {
        if (this.stream != null) {
            this.stream.close();
        }
        if (this.in != null) {
            this.in.close();
            this.in = ZipHandle.openStream(this.file);
        }
        if (this.zip != null) {
            this.zip.close();
        }
        this.zip = new ZipInputStream(this.in);
        if (this.entryName != null) {
            this.seekToEntry();
        }
        this.stream = new DataInputStream(new BufferedInputStream(this.zip, 0x100000));
        this.stream.mark(0x100000);
    }

    private void seekToEntry() throws IOException {
        while (!this.entryName.equals(this.zip.getNextEntry().getName())) {
        }
    }

    private void populateLength() throws IOException {
        this.length = -1L;
        while (this.stream.available() > 0) {
            this.stream.skip(1L);
            ++this.length;
        }
        this.resetStream();
    }

    private static IRandomAccess getHandle(String file2) throws IOException {
        return Location.getHandle(file2, false, false);
    }

    private static RandomAccessInputStream openStream(String file2) throws IOException {
        return new RandomAccessInputStream(ZipHandle.getHandle(file2), file2);
    }
}

