/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Macro;
import ij.gui.GenericDialog;
import ij.measure.Calibration;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import ij.process.LUT;
import java.awt.image.ColorModel;
import java.io.IOException;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.plugins.util.BFVirtualStack;
import loci.plugins.util.ImageProcessorReader;
import loci.plugins.util.LibraryChecker;
import loci.plugins.util.VirtualImagePlus;
import loci.plugins.util.WindowTools;

public class Slicer
implements PlugInFilter {
    public boolean canceled;
    private String arg;
    private ImagePlus imp;

    public ImagePlus[] reslice(ImagePlus imp, boolean sliceC, boolean sliceZ, boolean sliceT, String stackOrder) {
        ImageStack stack = imp.getImageStack();
        boolean hyperstack = imp.isHyperStack();
        Calibration calibration = imp.getCalibration();
        int sizeZ = imp.getNSlices();
        int sizeC = imp.getNChannels();
        int sizeT = imp.getNFrames();
        int slicesPerStack = stack.getSize();
        if (sliceZ) {
            slicesPerStack /= sizeZ;
        }
        if (sliceC) {
            slicesPerStack /= sizeC;
        }
        if (sliceT) {
            slicesPerStack /= sizeT;
        }
        int realSizeZ = sliceZ ? 1 : sizeZ;
        int realSizeC = sliceC ? 1 : sizeC;
        int realSizeT = sliceT ? 1 : sizeT;
        BFVirtualStack virtualStack = null;
        if (stack instanceof BFVirtualStack) {
            virtualStack = (BFVirtualStack)stack;
        }
        ImageStack[] newStacks = new ImageStack[stack.getSize() / slicesPerStack];
        for (int i = 0; i < newStacks.length; ++i) {
            newStacks[i] = this.makeStack(stack);
            if (newStacks[i] != null) continue;
            return null;
        }
        int stackZ = sliceZ ? sizeZ : 1;
        int stackC = sliceC ? sizeC : 1;
        int stackT = sliceT ? sizeT : 1;
        int[][] planeIndexes = new int[newStacks.length][slicesPerStack];
        for (int i = 0; i < sizeZ * sizeC * sizeT; ++i) {
            int[] zct = FormatTools.getZCTCoords(stackOrder, sizeZ, sizeC, sizeT, stack.getSize(), i);
            int stackNdx = FormatTools.getIndex(stackOrder, stackZ, stackC, stackT, newStacks.length, sliceZ ? zct[0] : 0, sliceC ? zct[1] : 0, sliceT ? zct[2] : 0);
            String label = stack.getSliceLabel(i + 1);
            if (virtualStack != null) {
                ((BFVirtualStack)newStacks[stackNdx]).addSlice(label);
                int sliceNdx = FormatTools.getIndex(stackOrder, realSizeZ, realSizeC, realSizeT, slicesPerStack, sliceZ ? 0 : zct[0], sliceC ? 0 : zct[1], sliceT ? 0 : zct[2]);
                planeIndexes[stackNdx][sliceNdx] = i;
                continue;
            }
            newStacks[stackNdx].addSlice(label, stack.getProcessor(i + 1));
        }
        ImagePlus[] newImps = new ImagePlus[newStacks.length];
        for (int i = 0; i < newStacks.length; ++i) {
            CompositeImage composite;
            if (virtualStack != null) {
                ((BFVirtualStack)newStacks[i]).setPlaneIndexes(planeIndexes[i]);
            }
            int[] zct = FormatTools.getZCTCoords(stackOrder, stackZ, stackC, stackT, newStacks.length, i);
            if (imp.isComposite() && (composite = (CompositeImage)imp).getMode() == 2) {
                LUT lut = composite.getChannelLut(zct[1] + 1);
                newStacks[i].setColorModel((ColorModel)lut);
            }
            String title = imp.getTitle();
            title = title + " -";
            if (sliceZ) {
                title = title + " Z=" + zct[0];
            }
            if (sliceT) {
                title = title + " T=" + zct[2];
            }
            if (sliceC) {
                title = title + " C=" + zct[1];
            }
            VirtualImagePlus p = null;
            if (virtualStack != null) {
                p = new VirtualImagePlus(title, newStacks[i]);
                p.setReader(virtualStack.getReader());
            } else {
                p = new ImagePlus(title, newStacks[i]);
            }
            p.setProperty("Info", imp.getProperty("Info"));
            p.setDimensions(realSizeC, realSizeZ, realSizeT);
            p.setCalibration(calibration);
            p.setFileInfo(imp.getOriginalFileInfo());
            if (!p.isComposite()) {
                p.setOpenAsHyperStack(hyperstack);
            }
            if (imp.isComposite() && !sliceC) {
                p = Slicer.reorder(p, stackOrder, "XYCZT");
                int mode = ((CompositeImage)imp).getMode();
                newImps[i] = new CompositeImage((ImagePlus)p, mode);
            } else {
                newImps[i] = p;
            }
            double max = imp.getDisplayRangeMax();
            double min = imp.getDisplayRangeMin();
            newImps[i].setDisplayRange(min, max);
            if (!imp.isComposite() || !newImps[i].isComposite()) continue;
            for (int c = 1; c < newImps[i].getNChannels(); ++c) {
                LUT originalLut = ((CompositeImage)imp).getChannelLut(c);
                LUT lut = ((CompositeImage)newImps[i]).getChannelLut(c);
                lut.min = originalLut.min;
                lut.max = originalLut.max;
            }
        }
        return newImps;
    }

    public static ImagePlus reorder(ImagePlus imp, String origOrder, String newOrder) {
        ImageStack s = imp.getStack();
        ImageStack newStack = new ImageStack(s.getWidth(), s.getHeight());
        int z = imp.getNSlices();
        int c = imp.getNChannels();
        int t = imp.getNFrames();
        int stackSize = s.getSize();
        for (int i = 0; i < stackSize; ++i) {
            int ndx = FormatTools.getReorderedIndex(origOrder, newOrder, z, c, t, stackSize, i);
            newStack.addSlice(s.getSliceLabel(ndx + 1), s.getProcessor(ndx + 1));
        }
        ImagePlus p = new ImagePlus(imp.getTitle(), newStack);
        p.setDimensions(c, z, t);
        p.setCalibration(imp.getCalibration());
        p.setFileInfo(imp.getOriginalFileInfo());
        return p;
    }

    public int setup(String arg, ImagePlus imp) {
        this.arg = arg;
        this.imp = imp;
        return 159;
    }

    public void run(ImageProcessor ip) {
        if (!LibraryChecker.checkJava() || !LibraryChecker.checkImageJ()) {
            return;
        }
        boolean sliceC = false;
        boolean sliceZ = false;
        boolean sliceT = false;
        String stackOrder = null;
        boolean keepOriginal = false;
        if (this.arg == null || this.arg.trim().equals("")) {
            GenericDialog gd = new GenericDialog("Slicing options...");
            gd.addCheckbox("Split_channels", false);
            gd.addCheckbox("Split_Z slices", false);
            gd.addCheckbox("Split_timepoints", false);
            gd.addCheckbox("Keep_original stack", false);
            gd.addChoice("Stack_order", new String[]{"XYCZT", "XYCTZ", "XYZCT", "XYZTC", "XYTCZ", "XYTZC"}, "XYCZT");
            gd.showDialog();
            if (gd.wasCanceled()) {
                this.canceled = true;
                return;
            }
            sliceC = gd.getNextBoolean();
            sliceZ = gd.getNextBoolean();
            sliceT = gd.getNextBoolean();
            keepOriginal = gd.getNextBoolean();
            stackOrder = gd.getNextChoice();
        } else {
            sliceC = this.getBooleanValue("split_channels");
            sliceZ = this.getBooleanValue("split_z");
            sliceT = this.getBooleanValue("split_timepoints");
            keepOriginal = this.getBooleanValue("keep_original");
            stackOrder = Macro.getValue((String)this.arg, (String)"stack_order", (String)"XYCZT");
        }
        if (this.imp.getImageStack().isVirtual()) {
            IJ.error((String)"Slicer plugin cannot be used with virtual stacks.\nPlease convert the virtual stack using Image>Duplicate.");
            return;
        }
        ImagePlus[] newImps = this.reslice(this.imp, sliceC, sliceZ, sliceT, stackOrder);
        if (!keepOriginal) {
            this.imp.close();
        }
        for (ImagePlus imp : newImps) {
            imp.show();
        }
    }

    private boolean getBooleanValue(String key) {
        return Boolean.valueOf(Macro.getValue((String)this.arg, (String)key, (String)"false"));
    }

    private ImageStack makeStack(ImageStack stack) {
        if (!(stack instanceof BFVirtualStack)) {
            return new ImageStack(stack.getWidth(), stack.getHeight());
        }
        BFVirtualStack virtualStack = (BFVirtualStack)stack;
        String path = virtualStack.getPath();
        ImageProcessorReader reader = virtualStack.getReader();
        try {
            return new BFVirtualStack(path, reader, false, false, false);
        }
        catch (FormatException e) {
            WindowTools.reportException(e);
        }
        catch (IOException e) {
            WindowTools.reportException(e);
        }
        return null;
    }
}

