/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import ome.xml.model.Instrument;
import ome.xml.model.ManufacturerSpec;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Reference;
import ome.xml.model.enums.DetectorType;
import ome.xml.model.enums.EnumerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Detector
extends ManufacturerSpec {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2012-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(Detector.class);
    private Double zoom;
    private Double amplificationGain;
    private Double gain;
    private Double offset;
    private DetectorType type;
    private String id;
    private Double voltage;
    private Instrument instrument;

    public Detector() {
    }

    public Detector(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public void update(Element element, OMEModel model) throws EnumerationException {
        super.update(element, model);
        String tagName = element.getTagName();
        if (!"Detector".equals(tagName)) {
            LOGGER.debug("Expecting node name of Detector got {}", (Object)tagName);
        }
        if (element.hasAttribute("Zoom")) {
            this.setZoom(Double.valueOf(element.getAttribute("Zoom")));
        }
        if (element.hasAttribute("AmplificationGain")) {
            this.setAmplificationGain(Double.valueOf(element.getAttribute("AmplificationGain")));
        }
        if (element.hasAttribute("Gain")) {
            this.setGain(Double.valueOf(element.getAttribute("Gain")));
        }
        if (element.hasAttribute("Offset")) {
            this.setOffset(Double.valueOf(element.getAttribute("Offset")));
        }
        if (element.hasAttribute("Type")) {
            this.setType(DetectorType.fromString(element.getAttribute("Type")));
        }
        if (!element.hasAttribute("ID") && this.getID() == null) {
            throw new RuntimeException(String.format("Detector missing required ID property.", new Object[0]));
        }
        if (element.hasAttribute("ID")) {
            this.setID(String.valueOf(element.getAttribute("ID")));
            model.addModelObject(this.getID(), this);
        }
        if (element.hasAttribute("Voltage")) {
            this.setVoltage(Double.valueOf(element.getAttribute("Voltage")));
        }
    }

    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", reference.getClass());
        return false;
    }

    public Double getZoom() {
        return this.zoom;
    }

    public void setZoom(Double zoom) {
        this.zoom = zoom;
    }

    public Double getAmplificationGain() {
        return this.amplificationGain;
    }

    public void setAmplificationGain(Double amplificationGain) {
        this.amplificationGain = amplificationGain;
    }

    public Double getGain() {
        return this.gain;
    }

    public void setGain(Double gain) {
        this.gain = gain;
    }

    public Double getOffset() {
        return this.offset;
    }

    public void setOffset(Double offset) {
        this.offset = offset;
    }

    public DetectorType getType() {
        return this.type;
    }

    public void setType(DetectorType type) {
        this.type = type;
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public Double getVoltage() {
        return this.voltage;
    }

    public void setVoltage(Double voltage) {
        this.voltage = voltage;
    }

    public Instrument getInstrument() {
        return this.instrument;
    }

    public void setInstrument(Instrument instrument_BackReference) {
        this.instrument = instrument_BackReference;
    }

    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    protected Element asXMLElement(Document document, Element Detector_element) {
        if (Detector_element == null) {
            Detector_element = document.createElementNS(NAMESPACE, "Detector");
        }
        if (this.zoom != null) {
            Detector_element.setAttribute("Zoom", this.zoom.toString());
        }
        if (this.amplificationGain != null) {
            Detector_element.setAttribute("AmplificationGain", this.amplificationGain.toString());
        }
        if (this.gain != null) {
            Detector_element.setAttribute("Gain", this.gain.toString());
        }
        if (this.offset != null) {
            Detector_element.setAttribute("Offset", this.offset.toString());
        }
        if (this.type != null) {
            Detector_element.setAttribute("Type", this.type.toString());
        }
        if (this.id != null) {
            Detector_element.setAttribute("ID", this.id.toString());
        }
        if (this.voltage != null) {
            Detector_element.setAttribute("Voltage", this.voltage.toString());
        }
        if (this.instrument != null) {
            // empty if block
        }
        return super.asXMLElement(document, Detector_element);
    }
}

