/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.bsse.cisd.dsu.dss.plugins;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.mail.EMailAddress;
import ch.systemsx.cisd.common.security.MD5ChecksumCalculator;
import ch.systemsx.cisd.common.string.Template;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.tasks.IProcessingPluginTask;
import ch.systemsx.cisd.openbis.dss.generic.shared.DataSetProcessingContext;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.ProcessingStatus;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ListSampleCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatasetDescription;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifierFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.util.ByteArrayDataSource;
import org.apache.log4j.Logger;

public class DataSetToSOFT
implements IProcessingPluginTask {
    @Private
    static final String EXTERNAL_SAMPLE_NAME_PROPERTY = "EXTERNAL_SAMPLE_NAME";
    private static final String EMPTY = "<<<NEED_TO_BE_FILLED>>>";
    @Private
    static final Template SOFT_FILE_NAME_TEMPLATE = new Template("${flow-lane}_${external-sample-name}_SOFT.txt");
    @Private
    static final Template E_MAIL_SUBJECT_TEMPLATE = new Template("SOFT file for '${external-sample-name}'");
    @Private
    static final Template E_MAIL_CONTENT_TEMPLATE = new Template("Dear User\n\nEnclosed you will find the SOFT file for '${external-sample-name}'.\nFlow lane: ${flow-lane}\nData Set: ${data-set}");
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, DataSetToSOFT.class);
    private static final long serialVersionUID = 1L;
    private final Map<String, String> translation = new HashMap<String, String>();
    private transient IEncapsulatedOpenBISService service;

    private static final String tryToGetProperty(Sample sample, String propertyTypeCode) {
        List<IEntityProperty> properties = sample.getProperties();
        for (IEntityProperty property : properties) {
            if (!property.getPropertyType().getCode().equals(propertyTypeCode)) continue;
            return property.tryGetAsString();
        }
        return null;
    }

    public DataSetToSOFT(Properties properties, File storeRoot) {
        this.translation.put("GENOMIC_DNA", "genomic");
        this.translation.put("FRAGMENTED_GENOMIC_DNA", "genomic");
        this.translation.put("CHIP", "genomic");
        this.translation.put("BISULFITE", "genomic");
        this.translation.put("NON_GENOMIC", "non-genomic");
        this.translation.put("SYNTHETIC", "synthetic");
        this.translation.put("VIRAL_RNA", "viral RNA");
        this.translation.put("SMALL_RNA", "other");
        this.translation.put("TOTAL_RNA", "other");
        this.translation.put("MRNA", "other");
        this.translation.put("PROCESSED_DNA_LIBRARY", EMPTY);
    }

    @Override
    public ProcessingStatus process(List<DatasetDescription> datasets, DataSetProcessingContext context) {
        EMailAddress address = new EMailAddress(context.getUserEmailOrNull());
        ProcessingStatus status = new ProcessingStatus();
        for (DatasetDescription datasetDescription : datasets) {
            try {
                String dataSetCode = datasetDescription.getDataSetCode();
                if (operationLog.isInfoEnabled()) {
                    operationLog.info((Object)("Create SOFT file for data set " + dataSetCode));
                }
                AbstractExternalData srfDataSet = this.getService().tryGetDataSet(dataSetCode);
                Sample flowLaneSample = this.getFlowLaneSample(srfDataSet);
                Sample flowCellSample = this.getFlowCellSample(flowLaneSample);
                Sample sequencingSample = this.getSequencingSample(flowLaneSample);
                File srfFile = this.tryToFindSrfFile(datasetDescription, context);
                if (srfFile == null) {
                    status.addDatasetStatus(datasetDescription, Status.createError("Data set " + dataSetCode + " has no srf file."));
                    continue;
                }
                String checkSum = this.calculateCheckSum(srfFile);
                SOFTBuilder softBuilder = new SOFTBuilder();
                softBuilder.addSample(sequencingSample, EXTERNAL_SAMPLE_NAME_PROPERTY);
                softBuilder.addProperty("type", "SRA");
                softBuilder.addSampleProperty("title", sequencingSample, EXTERNAL_SAMPLE_NAME_PROPERTY);
                softBuilder.addSampleProperty("source_name", sequencingSample, "SAMPLE_SOURCE_NAME");
                softBuilder.addSampleProperty("organism", sequencingSample, "NCBI_ORGANISM_TAXONOMY");
                softBuilder.addSampleProperty("characteristics", sequencingSample, "SAMPLE_CHARACTERISTICS");
                softBuilder.addSampleProperty("biomaterial_provider", sequencingSample, "CONTACT_PERSON_NAME");
                softBuilder.addSampleProperty("molecule", sequencingSample, "SAMPLE_MOLECULE");
                softBuilder.addSampleProperty("extract_protocol", sequencingSample, "SAMPLE_EXTRACT_PROTOCOL");
                softBuilder.addSampleProperty("data_processing", sequencingSample, "SAMPLE_DATA_PROCESSING");
                softBuilder.addSampleProperty("library_strategy", sequencingSample, "SAMPLE_LIBRARY_STRATEGY");
                softBuilder.addSampleProperty("library_source", sequencingSample, "SAMPLE_KIND", this.translation);
                softBuilder.addSampleProperty("library_selection", sequencingSample, "SAMPLE_LIBRARY_SELECTION");
                softBuilder.addSampleProperty("instrument_model", flowCellSample, "GENOME_ANALYZER");
                softBuilder.addProperty("raw_file_1", srfFile.getName());
                softBuilder.addProperty("raw_file_type_1", "srf");
                softBuilder.addProperty("file_checksum_1", checkSum);
                String subject = this.createSubject(sequencingSample);
                String content = this.createContent(sequencingSample, flowLaneSample, srfDataSet);
                String fileName = this.createSoftFileName(sequencingSample, flowLaneSample);
                DataSource dataSource = this.createDataSource(softBuilder.toString());
                context.getMailClient().sendEmailMessageWithAttachment(subject, content, fileName, new DataHandler(dataSource), null, null, address);
                status.addDatasetStatus(datasetDescription, Status.OK);
            }
            catch (Exception ex) {
                status.addDatasetStatus(datasetDescription, Status.createError("Exception occured: " + ex));
                operationLog.error((Object)("Exception occured while processing " + datasetDescription), (Throwable)ex);
            }
        }
        return status;
    }

    private String createSubject(Sample sequencingSample) {
        Template template = E_MAIL_SUBJECT_TEMPLATE.createFreshCopy();
        this.bindExternalSampleName(template, sequencingSample);
        return template.createText();
    }

    private String createContent(Sample sequencingSample, Sample flowLaneSample, AbstractExternalData dataSet) {
        Template template = E_MAIL_CONTENT_TEMPLATE.createFreshCopy();
        this.bindExternalSampleName(template, sequencingSample);
        template.bind("flow-lane", flowLaneSample.getIdentifier());
        template.bind("data-set", dataSet.getCode());
        return template.createText();
    }

    private String createSoftFileName(Sample sequencingSample, Sample flowLaneSample) {
        Template template = SOFT_FILE_NAME_TEMPLATE.createFreshCopy();
        String externalSampleName = DataSetToSOFT.tryToGetProperty(sequencingSample, EXTERNAL_SAMPLE_NAME_PROPERTY);
        template.bind("external-sample-name", externalSampleName.replace(' ', '_'));
        template.bind("flow-lane", flowLaneSample.getCode().replace(':', '-'));
        return template.createText();
    }

    private void bindExternalSampleName(Template template, Sample sequencingSample) {
        String externalSampleName = DataSetToSOFT.tryToGetProperty(sequencingSample, EXTERNAL_SAMPLE_NAME_PROPERTY);
        template.bind("external-sample-name", externalSampleName);
    }

    private String calculateCheckSum(File srfFile) {
        String checkSum;
        try {
            checkSum = MD5ChecksumCalculator.calculate(new FileInputStream(srfFile));
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
        }
        return checkSum;
    }

    private File tryToFindSrfFile(DatasetDescription datasetDescription, DataSetProcessingContext context) {
        return this.tryToFindSrfFile(context.getDirectoryProvider().getDataSetDirectory(datasetDescription));
    }

    private File tryToFindSrfFile(File file) {
        if (file.isFile() && file.getName().endsWith(".srf")) {
            return file;
        }
        if (file.isDirectory()) {
            File[] files;
            File[] fileArray = files = file.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                File srfFile = this.tryToFindSrfFile(child);
                if (srfFile != null) {
                    return srfFile;
                }
                ++n2;
            }
        }
        return null;
    }

    private Sample getFlowLaneSample(AbstractExternalData dataSet) {
        SampleIdentifier identifier = SampleIdentifierFactory.parse(dataSet.getSampleIdentifier());
        return this.getService().tryGetSampleWithExperiment(identifier);
    }

    private Sample getFlowCellSample(Sample flowLaneSample) {
        SampleIdentifier identifier = SampleIdentifierFactory.parse(flowLaneSample.getContainer().getIdentifier());
        return this.getService().tryGetSampleWithExperiment(identifier);
    }

    private Sample getSequencingSample(Sample flowLaneSample) {
        List<Sample> parents = this.getService().listSamples(ListSampleCriteria.createForChild(new TechId(flowLaneSample.getId())));
        return parents.get(0);
    }

    private DataSource createDataSource(String softData) {
        try {
            return new ByteArrayDataSource(softData, "text/plain");
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
        }
    }

    private IEncapsulatedOpenBISService getService() {
        if (this.service == null) {
            this.service = ServiceProvider.getOpenBISService();
        }
        return this.service;
    }

    void setService(IEncapsulatedOpenBISService service) {
        this.service = service;
    }

    private static final class SOFTBuilder {
        private final StringBuilder builder = new StringBuilder();

        private SOFTBuilder() {
        }

        void addSample(Sample sample, String propertyTypeCode) {
            this.addLine('^', "SAMPLE", this.getProperty(sample, propertyTypeCode));
        }

        void addSampleProperty(String key, Sample sample, String propertyTypeCode, Map<String, String> translation) {
            String property = this.getProperty(sample, propertyTypeCode);
            String translatedProperty = translation.get(property);
            this.addProperty(key, translatedProperty == null ? property : translatedProperty);
        }

        void addSampleProperty(String key, Sample sample, String propertyTypeCode) {
            this.addProperty(key, this.getProperty(sample, propertyTypeCode));
        }

        void addProperty(String key, String property) {
            this.addLine('!', "Sample_" + key, property);
        }

        private void addLine(char prefix, String key, String value) {
            this.builder.append(prefix).append(key).append(" = ").append(value).append('\n');
        }

        private String getProperty(Sample sample, String propertyTypeCode) {
            String property = DataSetToSOFT.tryToGetProperty(sample, propertyTypeCode);
            return property == null ? DataSetToSOFT.EMPTY : property;
        }

        public String toString() {
            return this.builder.toString();
        }
    }
}

