/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.bsse.cisd.dsu.tracking.email;

import ch.ethz.bsse.cisd.dsu.tracking.dto.TrackedEntities;
import ch.ethz.bsse.cisd.dsu.tracking.email.EntityTrackingEmailData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class EntityTrackingEmailDataManager {
    private static final String AFFILIATION = "AFFILIATION";
    private static final String CONTACT_PERSON_EMAIL = "CONTACT_PERSON_EMAIL";
    private static final String PRINCIPAL_INVESTIGATOR_EMAIL = "PRINCIPAL_INVESTIGATOR_EMAIL";
    private static Map<String, String> recipientsByAffiliation;

    EntityTrackingEmailDataManager() {
    }

    public static void initialize(Map<String, String> recipients) {
        recipientsByAffiliation = recipients;
    }

    public static Collection<EntityTrackingEmailData> groupByRecipient(TrackedEntities trackedEntities) {
        assert (recipientsByAffiliation != null) : "recipientsByAffiliation not initialized";
        HashMap<String, EntityTrackingEmailData> dataByRecipient = new HashMap<String, EntityTrackingEmailData>();
        EntityTrackingEmailDataManager.groupSequencingSamplesToBeProcessed(dataByRecipient, trackedEntities);
        EntityTrackingEmailDataManager.groupSequencingSamplesProcessed(dataByRecipient, trackedEntities);
        EntityTrackingEmailDataManager.groupDataSetSamples(dataByRecipient, trackedEntities);
        return dataByRecipient.values();
    }

    private static void groupSequencingSamplesToBeProcessed(Map<String, EntityTrackingEmailData> result, TrackedEntities trackedEntities) {
        for (Sample sequencingSample : trackedEntities.getSequencingSamplesToBeProcessed()) {
            for (String recipient : EntityTrackingEmailDataManager.getSequencingSampleTrackingRecipients(Collections.singleton(sequencingSample))) {
                EntityTrackingEmailData emailData = EntityTrackingEmailDataManager.getOrCreateRecipientEmailData(result, recipient);
                emailData.addSequencingSampleToBeProcessed(sequencingSample);
            }
        }
    }

    private static void groupSequencingSamplesProcessed(Map<String, EntityTrackingEmailData> result, TrackedEntities trackedEntities) {
        for (Sample sequencingSample : trackedEntities.getSequencingSamplesProcessed()) {
            for (String recipient : EntityTrackingEmailDataManager.getSequencingSampleTrackingRecipients(Collections.singleton(sequencingSample))) {
                EntityTrackingEmailData emailData = EntityTrackingEmailDataManager.getOrCreateRecipientEmailData(result, recipient);
                emailData.addSequencingSampleProcessed(sequencingSample);
            }
        }
    }

    private static void groupDataSetSamples(Map<String, EntityTrackingEmailData> result, TrackedEntities trackedEntities) {
        for (AbstractExternalData dataSet : trackedEntities.getDataSets()) {
            for (String recipient : EntityTrackingEmailDataManager.getDataSetTrackingRecipients(dataSet)) {
                EntityTrackingEmailData emailData = EntityTrackingEmailDataManager.getOrCreateRecipientEmailData(result, recipient);
                emailData.addDataSet(dataSet);
            }
        }
    }

    private static EntityTrackingEmailData getOrCreateRecipientEmailData(Map<String, EntityTrackingEmailData> dataByRecipient, String recipient) {
        EntityTrackingEmailData emailDataOrNull = dataByRecipient.get(recipient);
        if (emailDataOrNull == null) {
            emailDataOrNull = new EntityTrackingEmailData(recipient);
            dataByRecipient.put(recipient, emailDataOrNull);
        }
        return emailDataOrNull;
    }

    private static Set<String> getSequencingSampleTrackingRecipients(Collection<Sample> sequencingSamples) {
        assert (sequencingSamples != null);
        HashSet<String> recipients = new HashSet<String>();
        HashSet<String> recipientPropertyTypeCodes = new HashSet<String>();
        recipientPropertyTypeCodes.add(CONTACT_PERSON_EMAIL);
        recipientPropertyTypeCodes.add(PRINCIPAL_INVESTIGATOR_EMAIL);
        for (Sample sequencingSample : sequencingSamples) {
            for (IEntityProperty property : sequencingSample.getProperties()) {
                String affiliationRecipientOrNull;
                String propertyCode = property.getPropertyType().getCode();
                String propertyValue = property.tryGetAsString();
                if (recipientPropertyTypeCodes.contains(propertyCode)) {
                    recipients.add(propertyValue);
                    continue;
                }
                if (!propertyCode.equals(AFFILIATION) || (affiliationRecipientOrNull = recipientsByAffiliation.get(propertyValue)) == null) continue;
                recipients.add(affiliationRecipientOrNull);
            }
        }
        return recipients;
    }

    private static Set<String> getFlowLaneSampleTrackingRecipients(Sample flowLaneSample) {
        assert (flowLaneSample != null);
        return EntityTrackingEmailDataManager.getSequencingSampleTrackingRecipients(flowLaneSample.getParents());
    }

    private static Set<String> getDataSetTrackingRecipients(AbstractExternalData dataSet) {
        assert (dataSet != null);
        return EntityTrackingEmailDataManager.getFlowLaneSampleTrackingRecipients(dataSet.getSample());
    }
}

