/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.etlserver.DefaultDataSetInfoExtractor;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;

public class SmartParentDataSetInfoExtractor
extends DefaultDataSetInfoExtractor {
    @Private
    static final String SMART_PARENT_DATA_SET_RESOLUTION_DATASET_TYPE = "smart-parent-data-set-resolution-dataset-type";
    @Private
    static final String SMART_PARENT_DATA_SET_RESOLUTION_MANY_PARENTS_MODE = "smart-parent-data-set-resolution-many-parents-mode";
    @Private
    static final String SMART_PARENT_DATA_SET_RESOLUTION_FAIL_IF_MISSING = "smart-parent-data-set-resolution-fail-if-missing";
    private final String datasetTypePatternOrNull;
    private final ManyParentsModeEnum manyParentsMode;
    private final boolean failWhenParentMissing;

    public SmartParentDataSetInfoExtractor(Properties properties) {
        super(properties);
        this.datasetTypePatternOrNull = properties.getProperty(SMART_PARENT_DATA_SET_RESOLUTION_DATASET_TYPE);
        if (this.datasetTypePatternOrNull != null && !this.indexOfParentDataSetCodes.isUndefined()) {
            throw new ConfigurationFailureException(String.format("'%s' and '%s' specified at the same time.", SMART_PARENT_DATA_SET_RESOLUTION_DATASET_TYPE, "index-of-parent-data-set-codes"));
        }
        String manyMode = properties.getProperty(SMART_PARENT_DATA_SET_RESOLUTION_MANY_PARENTS_MODE, ManyParentsModeEnum.FAIL.name());
        this.manyParentsMode = ManyParentsModeEnum.valueOf(manyMode);
        this.failWhenParentMissing = PropertyUtils.getBoolean(properties, SMART_PARENT_DATA_SET_RESOLUTION_FAIL_IF_MISSING, true);
    }

    @Override
    public DataSetInformation getDataSetInformation(File incomingDataSetPath, IEncapsulatedOpenBISService openbisService) throws EnvironmentFailureException, UserFailureException {
        List<AbstractExternalData> datasets;
        DataSetInformation dataSetInformation = super.getDataSetInformation(incomingDataSetPath, openbisService);
        if (this.datasetTypePatternOrNull != null && (datasets = this.tryFetchParentCandidates(openbisService, dataSetInformation)) != null) {
            datasets = SmartParentDataSetInfoExtractor.filterByTypePattern(datasets, this.datasetTypePatternOrNull);
            List<String> parentDatasetCodes = this.getParentDatasetCodes(dataSetInformation, datasets);
            dataSetInformation.setParentDataSetCodes(parentDatasetCodes);
        }
        return dataSetInformation;
    }

    private static List<AbstractExternalData> filterByTypePattern(List<AbstractExternalData> datasets, String datasetTypePatternOrNull) {
        ArrayList<AbstractExternalData> filtered = new ArrayList<AbstractExternalData>();
        for (AbstractExternalData dataset : datasets) {
            if (!dataset.getEntityType().getCode().matches(datasetTypePatternOrNull)) continue;
            filtered.add(dataset);
        }
        return filtered;
    }

    private List<AbstractExternalData> tryFetchParentCandidates(IEncapsulatedOpenBISService openbisService, DataSetInformation dataSetInformation) {
        List<AbstractExternalData> datasets = null;
        SampleIdentifier sampleIdentifier = dataSetInformation.getSampleIdentifier();
        if (sampleIdentifier != null) {
            Sample sample = openbisService.tryGetSampleWithExperiment(sampleIdentifier);
            datasets = openbisService.listDataSetsBySampleID(sample.getId(), true);
        } else {
            Experiment experiment = dataSetInformation.tryToGetExperiment();
            if (experiment != null) {
                datasets = openbisService.listDataSetsByExperimentID(experiment.getId());
            }
        }
        return datasets;
    }

    private List<String> getParentDatasetCodes(DataSetInformation dataSetInformation, List<AbstractExternalData> datasets) {
        if (datasets.size() == 0) {
            if (this.failWhenParentMissing) {
                throw UserFailureException.fromTemplate("No parent datasets of the type '%s' connected to the same sample/experiment could be found.", this.datasetTypePatternOrNull);
            }
            return new ArrayList<String>();
        }
        if (datasets.size() > 1) {
            if (this.manyParentsMode == ManyParentsModeEnum.FAIL) {
                throw UserFailureException.fromTemplate("More than one parent dataset of the type '%s' connected to the same sample/experiment has been found.", new Object[0]);
            }
            if (this.manyParentsMode == ManyParentsModeEnum.CHOOSE_NONE) {
                return new ArrayList<String>();
            }
            if (this.manyParentsMode == ManyParentsModeEnum.CHOOSE_ALL) {
                return SmartParentDataSetInfoExtractor.extractCodes(datasets);
            }
            if (this.manyParentsMode == ManyParentsModeEnum.CHOOSE_YOUNGEST) {
                return Arrays.asList(this.selectLastRegistered(datasets).getCode());
            }
            throw new IllegalStateException("Unhandled mode " + (Object)((Object)this.manyParentsMode));
        }
        return Arrays.asList(datasets.get(0).getCode());
    }

    private AbstractExternalData selectLastRegistered(List<AbstractExternalData> datasets) {
        AbstractExternalData lastRegistered = null;
        for (AbstractExternalData dataset : datasets) {
            if (lastRegistered != null && dataset.getRegistrationDate().getTime() <= lastRegistered.getRegistrationDate().getTime()) continue;
            lastRegistered = dataset;
        }
        return lastRegistered;
    }

    private static List<String> extractCodes(List<AbstractExternalData> datasets) {
        ArrayList<String> codes = new ArrayList<String>();
        for (AbstractExternalData dataset : datasets) {
            codes.add(dataset.getCode());
        }
        return codes;
    }

    private static enum ManyParentsModeEnum {
        CHOOSE_YOUNGEST,
        CHOOSE_ALL,
        CHOOSE_NONE,
        FAIL;

    }
}

