/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.plugins;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.logging.ISimpleLogger;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.logging.LogLevel;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.etlserver.plugins.IDataSetMover;
import ch.systemsx.cisd.etlserver.plugins.ISegmentedStoreShuffling;
import ch.systemsx.cisd.etlserver.postregistration.EagerShufflingTask;
import ch.systemsx.cisd.etlserver.postregistration.IPostRegistrationTask;
import ch.systemsx.cisd.etlserver.postregistration.TaskExecutor;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.Share;
import ch.systemsx.cisd.openbis.generic.shared.dto.SimpleDataSetInformationDTO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;

public class SimpleShuffling
implements ISegmentedStoreShuffling {
    @Private
    static final String MINIMUM_FREE_SPACE_KEY = "minimum-free-space-in-MB";
    private final long minimumFreeSpace;
    private IPostRegistrationTask shufflingTask;
    private TaskExecutor taskExecutor;

    public SimpleShuffling(Properties properties) {
        this(properties, new EagerShufflingTask(properties, ServiceProvider.getOpenBISService()));
    }

    SimpleShuffling(Properties properties, IPostRegistrationTask shufflingTask) {
        this.shufflingTask = shufflingTask;
        this.minimumFreeSpace = 0x100000L * PropertyUtils.getLong(properties, MINIMUM_FREE_SPACE_KEY, 1024L);
        this.taskExecutor = new TaskExecutor(properties, LogFactory.getLogger(LogCategory.OPERATION, SimpleShuffling.class));
    }

    @Override
    public void init(ISimpleLogger logger) {
        this.taskExecutor.cleanup();
        logger.log(LogLevel.INFO, "Simple shuffling strategy initialized");
    }

    @Override
    public void shuffleDataSets(List<Share> sourceShares, List<Share> targetShares, IEncapsulatedOpenBISService service, IDataSetMover dataSetMover, ISimpleLogger logger) {
        List<ShareAndFreeSpace> fullShares = this.getFullShares(sourceShares);
        for (ShareAndFreeSpace fullShare : fullShares) {
            int numberOfDataSetsToMove;
            Share share = fullShare.getShare();
            List<SimpleDataSetInformationDTO> dataSets = share.getDataSetsOrderedBySize();
            long initalFreeSpaceAboveMinimum = fullShare.getFreeSpace() - this.minimumFreeSpace;
            if (share.isWithdrawShare()) {
                numberOfDataSetsToMove = dataSets.size();
                logger.log(LogLevel.INFO, "All " + numberOfDataSetsToMove + " data sets should be moved for share " + share.getShareId());
            } else {
                logger.log(LogLevel.INFO, "BEGIN Computing number of data sets to be moved for share " + share.getShareId());
                numberOfDataSetsToMove = this.getNumberOfDataSetsToMove(dataSets, initalFreeSpaceAboveMinimum, logger);
                logger.log(LogLevel.INFO, "END Computing number of data sets to move for share " + share.getShareId());
                if (numberOfDataSetsToMove < 0) {
                    throw new IllegalStateException("Share " + share.getShareId() + " has not enough free space even if it is empty.");
                }
            }
            int i = 0;
            while (i < numberOfDataSetsToMove) {
                SimpleDataSetInformationDTO dataSet = dataSets.get(i);
                try {
                    this.taskExecutor.execute(this.shufflingTask, "shuffling", dataSet.getDataSetCode(), false);
                }
                catch (Throwable throwable) {}
                ++i;
            }
        }
    }

    private int getNumberOfDataSetsToMove(List<SimpleDataSetInformationDTO> dataSets, long initalFreeSpaceAboveMinimum, ISimpleLogger logger) {
        long freeSpaceAboveMinimum = initalFreeSpaceAboveMinimum;
        long spaceBelowMinimum = freeSpaceAboveMinimum * -1L;
        float spaceBelowMinimumkB = (float)spaceBelowMinimum / 1024.0f;
        float spaceBelowMinimumMB = spaceBelowMinimumkB / 1024.0f;
        String freeSpaceString = String.format("\tSpace needed to free: %d bytes (%.2f kB, %.2f MB)", spaceBelowMinimum, Float.valueOf(spaceBelowMinimumkB), Float.valueOf(spaceBelowMinimumMB));
        logger.log(LogLevel.INFO, freeSpaceString);
        logger.log(LogLevel.INFO, "\tInspecting " + dataSets.size() + " data sets.");
        int i = 0;
        while (i < dataSets.size()) {
            if (freeSpaceAboveMinimum > 0L) {
                logger.log(LogLevel.INFO, "\t" + i + " data sets to move, available space : " + freeSpaceAboveMinimum);
                return i;
            }
            freeSpaceAboveMinimum += dataSets.get(i).getDataSetSize().longValue();
            ++i;
        }
        return freeSpaceAboveMinimum > 0L ? dataSets.size() : -1;
    }

    private List<ShareAndFreeSpace> getFullShares(List<Share> sourceShares) {
        ArrayList<ShareAndFreeSpace> fullShares = new ArrayList<ShareAndFreeSpace>();
        for (ShareAndFreeSpace shareState : this.getSortedShares(sourceShares)) {
            if (!shareState.getShare().isWithdrawShare() && shareState.getFreeSpace() >= this.minimumFreeSpace) continue;
            fullShares.add(shareState);
        }
        return fullShares;
    }

    private List<ShareAndFreeSpace> getSortedShares(List<Share> shares) {
        ArrayList<ShareAndFreeSpace> shareStates = new ArrayList<ShareAndFreeSpace>();
        for (Share share : shares) {
            shareStates.add(new ShareAndFreeSpace(share));
        }
        Collections.sort(shareStates, new Comparator<ShareAndFreeSpace>(){

            @Override
            public int compare(ShareAndFreeSpace o1, ShareAndFreeSpace o2) {
                long s2;
                long s1 = o1.getFreeSpace();
                return s1 < (s2 = o2.getFreeSpace()) ? -1 : (s1 > s2 ? 1 : 0);
            }
        });
        return shareStates;
    }

    private static final class ShareAndFreeSpace {
        private final Share share;
        private long freeSpace;

        ShareAndFreeSpace(Share share) {
            this.share = share;
            this.freeSpace = share.calculateFreeSpace();
        }

        long getFreeSpace() {
            return this.freeSpace;
        }

        Share getShare() {
            return this.share;
        }
    }
}

