/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.registrator.api.impl;

import ch.systemsx.cisd.common.io.PersistentExtendedBlockingQueueDecorator;
import ch.systemsx.cisd.common.io.PersistentExtendedBlockingQueueFactory;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.etlserver.registrator.IRollbackStack;
import ch.systemsx.cisd.etlserver.registrator.ITransactionalCommand;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Queue;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.log4j.Logger;

public class RollbackStack
implements IRollbackStack {
    private final File queue1File;
    private final File queue2File;
    private final File lockedMarkerFile;
    private final Logger operationLog;
    private PersistentExtendedBlockingQueueDecorator<StackElement> liveLifo;
    private PersistentExtendedBlockingQueueDecorator<StackElement> tempLifo;

    public RollbackStack(File queue1File, File queue2File) {
        this(queue1File, queue2File, null);
    }

    public RollbackStack(File queue1File, File queue2File, Logger operationLog) {
        this.queue1File = queue1File;
        this.queue2File = queue2File;
        this.operationLog = operationLog == null ? LogFactory.getLogger(LogCategory.OPERATION, RollbackStack.class) : operationLog;
        this.lockedMarkerFile = new File(queue1File.getParentFile(), String.valueOf(queue1File.getName()) + ".LOCKED");
        PersistentExtendedBlockingQueueDecorator<StackElement> queue1 = PersistentExtendedBlockingQueueFactory.createSmartQueue(queue1File, false);
        PersistentExtendedBlockingQueueDecorator<StackElement> queue2 = PersistentExtendedBlockingQueueFactory.createSmartQueue(queue2File, false);
        if (RollbackStack.bothQueuesAreEmpty(queue1, queue2)) {
            this.liveLifo = queue1;
            this.tempLifo = queue2;
        } else if (queue2.isEmpty()) {
            this.liveLifo = queue1;
            this.tempLifo = queue2;
        } else if (queue1.isEmpty()) {
            this.liveLifo = queue2;
            this.tempLifo = queue1;
        } else {
            if (((StackElement)queue2.peek()).order == 0) {
                this.liveLifo = queue1;
                this.tempLifo = queue2;
            } else {
                assert (((StackElement)queue1.peek()).order == 0);
                this.liveLifo = queue2;
                this.tempLifo = queue1;
            }
            while (this.liveLifo.size() > 0) {
                this.tempLifo.add((StackElement)this.liveLifo.peek());
                this.liveLifo.remove();
            }
            this.swapStacks();
        }
    }

    public int size() {
        return this.liveLifo.size();
    }

    @Override
    public void pushAndExecuteCommand(ITransactionalCommand cmd) {
        StackElement elt = new StackElement(cmd, this.liveLifo.size());
        this.liveLifo.add(elt);
        cmd.execute();
    }

    ITransactionalCommand rollbackAndPop() {
        StackElement elt = this.peek();
        try {
            elt.command.rollback();
        }
        catch (Throwable ex) {
            this.operationLog.error((Object)("Encountered error rolling back command " + elt.toString()), ex);
        }
        this.liveLifo.remove();
        this.swapStacks();
        return elt.command;
    }

    public ITransactionalCommand pop() {
        StackElement elt = this.peek();
        this.liveLifo.remove();
        this.swapStacks();
        return elt.command;
    }

    /*
     * Unable to fully structure code
     */
    StackElement peek() {
        if (this.liveLifo.size() >= 1) ** GOTO lbl7
        return null;
lbl-1000:
        // 1 sources

        {
            this.tempLifo.add((StackElement)this.liveLifo.peek());
            this.liveLifo.remove();
lbl7:
            // 2 sources

            ** while (this.liveLifo.size() > 1)
        }
lbl8:
        // 1 sources

        return (StackElement)this.liveLifo.peek();
    }

    public void rollbackAll() {
        this.rollbackAll(new IRollbackStackDelegate(){

            @Override
            public void willContinueRollbackAll(RollbackStack stack) {
            }
        });
    }

    public void rollbackAll(IRollbackStackDelegate delegate) {
        if (this.isLockedState()) {
            throw new IllegalStateException("Rollback stack is in the locked state. Triggering rollback forbidden.");
        }
        this.operationLog.info((Object)("Rolling back stack " + this));
        while (this.size() > 0) {
            delegate.willContinueRollbackAll(this);
            this.rollbackAndPop();
        }
    }

    public void discard() {
        if (this.isLockedState()) {
            throw new IllegalStateException("Discarding of locked rollback stack is illegal. Set locked to false first.");
        }
        this.liveLifo.close();
        this.tempLifo.close();
        this.liveLifo = null;
        this.tempLifo = null;
        this.queue1File.delete();
        this.queue2File.delete();
    }

    public File[] getBackingFiles() {
        return new File[]{this.queue1File, this.queue2File};
    }

    @Override
    public void setLockedState(boolean lockedState) {
        if (!lockedState && this.isLockedState()) {
            this.deleteLockedMarkerFile();
        } else if (lockedState && !this.isLockedState()) {
            this.createLockedMarkerFile();
        }
    }

    @Override
    public boolean isLockedState() {
        return this.lockedMarkerFile.exists();
    }

    private void deleteLockedMarkerFile() {
        this.lockedMarkerFile.delete();
    }

    private void createLockedMarkerFile() {
        try {
            this.lockedMarkerFile.createNewFile();
        }
        catch (IOException iOException) {
            this.operationLog.fatal((Object)("Failed to create rollback stack lock marker file " + this.lockedMarkerFile.getAbsolutePath()));
        }
    }

    private void swapStacks() {
        PersistentExtendedBlockingQueueDecorator<StackElement> swap = this.liveLifo;
        this.liveLifo = this.tempLifo;
        this.tempLifo = swap;
    }

    private static boolean bothQueuesAreEmpty(Queue<StackElement> queue1, Queue<StackElement> queue2) {
        return queue1.isEmpty() && queue2.isEmpty();
    }

    public String toString() {
        ToStringBuilder sb = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        sb.append(this.liveLifo.toArray());
        return sb.toString();
    }

    @Deprecated
    void doNotCallJustForTesting_MoveOneElement() {
        this.tempLifo.add((StackElement)this.liveLifo.peek());
        this.liveLifo.remove();
    }

    @Deprecated
    void doNotCallJustForTesting_PartiallyMoveOneElement() {
        this.tempLifo.add((StackElement)this.liveLifo.peek());
    }

    public static interface IRollbackStackDelegate {
        public void willContinueRollbackAll(RollbackStack var1);
    }

    protected static class StackElement
    implements Serializable,
    Comparable<StackElement> {
        private static final long serialVersionUID = 1L;
        private final ITransactionalCommand command;
        private final int order;

        protected StackElement(ITransactionalCommand command, int order) {
            this.command = command;
            this.order = order;
        }

        @Override
        public int compareTo(StackElement o) {
            if (o.order < this.order) {
                return -1;
            }
            if (o.order > this.order) {
                return 1;
            }
            return 0;
        }

        public String toString() {
            return "StackElement [command=" + this.command + ", order=" + this.order + "]";
        }
    }
}

