/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.registrator.api.v1.impl;

import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedBasicOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v1.IDataSetImmutable;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.Translator;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.ControlledVocabularyPropertyType;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSetType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetTypePropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetTypeWithVocabularyTerms;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Vocabulary;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTerm;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

abstract class AbstractDataSetImmutable
implements IDataSetImmutable {
    protected final IEncapsulatedBasicOpenBISService service;

    AbstractDataSetImmutable(IEncapsulatedBasicOpenBISService service) {
        this.service = service;
    }

    protected DataSetType getDataSetTypeWithPropertyTypes(String dataSetTypeCode) {
        DataSetTypeWithVocabularyTerms dataSetType = this.service.getDataSetType(dataSetTypeCode);
        HashMap<Vocabulary, List<ControlledVocabularyPropertyType.VocabularyTerm>> termsMap = new HashMap<Vocabulary, List<ControlledVocabularyPropertyType.VocabularyTerm>>();
        List<DataSetTypePropertyType> propertyTypes = dataSetType.getDataSetType().getAssignedPropertyTypes();
        for (DataSetTypePropertyType dataSetTypePropertyType : propertyTypes) {
            Vocabulary vocabulary = dataSetTypePropertyType.getPropertyType().getVocabulary();
            if (vocabulary == null) continue;
            Collection<VocabularyTerm> vocabularyTerms = this.service.listVocabularyTerms(vocabulary.getCode());
            termsMap.put(vocabulary, Translator.translatePropertyTypeTerms(vocabularyTerms));
        }
        return Translator.translate(dataSetType.getDataSetType(), termsMap);
    }
}

