/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.registrator.recovery;

import ch.systemsx.cisd.etlserver.DssRegistrationLogger;
import ch.systemsx.cisd.etlserver.registrator.DataSetFile;
import ch.systemsx.cisd.etlserver.registrator.DataSetRegistrationPersistentMap;
import ch.systemsx.cisd.etlserver.registrator.IRollbackStack;
import ch.systemsx.cisd.etlserver.registrator.recovery.AbstractRecoveryState;
import ch.systemsx.cisd.etlserver.registrator.recovery.DataSetStoragePrecommitRecoveryAlgorithm;
import ch.systemsx.cisd.etlserver.registrator.v2.AbstractOmniscientTopLevelDataSetRegistrator;
import ch.systemsx.cisd.etlserver.registrator.v2.DataSetStorageAlgorithm;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import java.util.ArrayList;
import java.util.List;

public class DataSetStoragePrecommitRecoveryState<T extends DataSetInformation>
extends AbstractRecoveryState<T> {
    private static final long serialVersionUID = 1L;
    private final TechId registrationId;
    private final List<DataSetStoragePrecommitRecoveryAlgorithm<T>> dataSetRecoveryStorageAlgorithms;

    public DataSetStoragePrecommitRecoveryState(TechId registrationId, List<DataSetStorageAlgorithm<T>> dataSetStorageAlgorithms, DssRegistrationLogger logger, IRollbackStack rollbackStack, DataSetFile incomingDataSetFile, DataSetRegistrationPersistentMap persistentMap) {
        super(logger, rollbackStack, incomingDataSetFile, persistentMap);
        this.registrationId = registrationId;
        this.dataSetRecoveryStorageAlgorithms = new ArrayList<DataSetStoragePrecommitRecoveryAlgorithm<T>>();
        for (DataSetStorageAlgorithm<T> algorithm : dataSetStorageAlgorithms) {
            this.dataSetRecoveryStorageAlgorithms.add(algorithm.getPrecommitRecoveryAlgorithm());
        }
    }

    public TechId getRegistrationId() {
        return this.registrationId;
    }

    public List<String> getDataSetCodes() {
        ArrayList<String> dataSetCodes = new ArrayList<String>();
        for (DataSetStoragePrecommitRecoveryAlgorithm<T> recoveryAlgorithm : this.dataSetRecoveryStorageAlgorithms) {
            dataSetCodes.add(recoveryAlgorithm.getDataSetCode());
        }
        return dataSetCodes;
    }

    @Override
    public ArrayList<DataSetStorageAlgorithm<T>> getDataSetStorageAlgorithms(AbstractOmniscientTopLevelDataSetRegistrator.OmniscientTopLevelDataSetRegistratorState state) {
        ArrayList<DataSetStorageAlgorithm<T>> algorithms = new ArrayList<DataSetStorageAlgorithm<T>>();
        for (DataSetStoragePrecommitRecoveryAlgorithm<T> recoveryAlgorithm : this.dataSetRecoveryStorageAlgorithms) {
            algorithms.add(recoveryAlgorithm.recoverDataSetStorageAlgorithm(state));
        }
        return algorithms;
    }
}

