/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.utils;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.etlserver.IPreRegistrationAction;
import ch.systemsx.cisd.etlserver.utils.AbstractPreOrPostRegistrationExecutor;
import org.apache.log4j.Logger;

public class PreRegistrationExecutor
extends AbstractPreOrPostRegistrationExecutor
implements IPreRegistrationAction {
    static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, PreRegistrationExecutor.class);
    static final Logger machineLog = LogFactory.getLogger(LogCategory.MACHINE, PreRegistrationExecutor.class);

    public static IPreRegistrationAction create(String scriptPath) {
        if (scriptPath != null) {
            return new PreRegistrationExecutor(scriptPath);
        }
        operationLog.debug((Object)"No pre-registration script found, skipping execution.");
        return new PreRegistrationEmptyScriptExecutor();
    }

    private PreRegistrationExecutor(String script) {
        super(script);
        operationLog.info((Object)(String.valueOf(this.getExecutorAdjectivalDescription()) + " script: " + script));
    }

    @Override
    public boolean execute(String dataSetCode, String dataSetAbsolutePathInDropbox) {
        return PreRegistrationExecutor.callScript(operationLog, machineLog, this.scriptPath, dataSetCode, dataSetAbsolutePathInDropbox);
    }

    @Override
    protected String getExecutorAdjectivalDescription() {
        return "pre-registration";
    }

    private static class PreRegistrationEmptyScriptExecutor
    extends AbstractPreOrPostRegistrationExecutor.EmptyScriptExecutor
    implements IPreRegistrationAction {
        private PreRegistrationEmptyScriptExecutor() {
        }
    }
}

