/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.etl.dto.api.v1.transformations;

import ch.systemsx.cisd.base.annotation.JsonObject;
import ch.systemsx.cisd.base.image.IImageTransformer;
import ch.systemsx.cisd.base.image.IImageTransformerFactory;
import ch.systemsx.cisd.common.image.IntensityRescaling;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.EnumSet;

@JsonObject(value="AutoRescaleIntensityImageTransformerFactory_obsolete")
public class AutoRescaleIntensityImageTransformerFactory
implements IImageTransformerFactory {
    private static final long serialVersionUID = 1L;
    private final float threshold;

    public AutoRescaleIntensityImageTransformerFactory(float threshold) {
        this.threshold = threshold;
    }

    public IImageTransformer createTransformer() {
        return new IImageTransformer(){

            public BufferedImage transform(BufferedImage image) {
                if (IntensityRescaling.isNotGrayscale(image)) {
                    EnumSet<IntensityRescaling.Channel> channels = IntensityRescaling.getUsedRgbChannels(image);
                    if (channels.size() != 1) {
                        return image;
                    }
                    IntensityRescaling.Channel channel = (IntensityRescaling.Channel)((Object)channels.iterator().next());
                    IntensityRescaling.Levels levels = IntensityRescaling.computeLevels(AutoRescaleIntensityImageTransformerFactory.this.toGrayScale(image, channel), AutoRescaleIntensityImageTransformerFactory.this.threshold);
                    return IntensityRescaling.rescaleIntensityLevelTo8Bits(image, levels, channel);
                }
                IntensityRescaling.Levels levels = IntensityRescaling.computeLevels(image, AutoRescaleIntensityImageTransformerFactory.this.threshold);
                return IntensityRescaling.rescaleIntensityLevelTo8Bits(image, levels);
            }
        };
    }

    private BufferedImage toGrayScale(BufferedImage image, IntensityRescaling.Channel channel) {
        BufferedImage gray = new BufferedImage(image.getWidth(), image.getHeight(), 10);
        WritableRaster raster = gray.getRaster();
        int y = 0;
        while (y < image.getHeight()) {
            int x = 0;
            while (x < image.getWidth()) {
                int value = image.getRGB(x, y) >> channel.getShift() & 0xFF;
                raster.setPixel(x, y, new int[]{value});
                ++x;
            }
            ++y;
        }
        return gray;
    }
}

