/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.etl.genedata;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.etlserver.DefaultDataSetInfoExtractor;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import java.io.File;
import java.util.Arrays;
import java.util.Properties;

public class DataSetInfoExtractorForImageAnalysis
extends DefaultDataSetInfoExtractor {
    public DataSetInfoExtractorForImageAnalysis(Properties properties) {
        super(properties);
    }

    @Override
    public DataSetInformation getDataSetInformation(File incomingDataSetPath, IEncapsulatedOpenBISService openbisService) throws EnvironmentFailureException, UserFailureException {
        DataSetInformation dataSetInformation = super.getDataSetInformation(incomingDataSetPath, openbisService);
        String parentDataSetCode = String.valueOf(dataSetInformation.getSpaceCode()) + "-" + dataSetInformation.getSampleCode();
        parentDataSetCode = parentDataSetCode.toUpperCase();
        dataSetInformation.setParentDataSetCodes(Arrays.asList(parentDataSetCode));
        Sample sample = openbisService.tryGetSampleWithExperiment(dataSetInformation.getSampleIdentifier());
        if (sample == null) {
            throw UserFailureException.fromTemplate("Cannot register dataset %s because the sample %s does not exist.", dataSetInformation.getDataSetCode(), dataSetInformation.getSampleIdentifier());
        }
        Experiment experiment = sample.getExperiment();
        dataSetInformation.setExperiment(experiment);
        dataSetInformation.setExperimentIdentifier(new ExperimentIdentifier(experiment));
        dataSetInformation.setSample(null);
        dataSetInformation.setSampleCode(null);
        return dataSetInformation;
    }
}

