/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.db.DBUtils;
import ch.systemsx.cisd.openbis.dss.generic.shared.IDataSetPathInfoProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.ISingleDataSetPathInfoProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetPathInfo;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.PathInfoDataSourceProvider;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import net.lemnik.eodsql.BaseQuery;
import net.lemnik.eodsql.QueryTool;
import net.lemnik.eodsql.Select;

public class DatabaseBasedDataSetPathInfoProvider
implements IDataSetPathInfoProvider {
    private IPathInfoDAO dao;

    public DatabaseBasedDataSetPathInfoProvider() {
    }

    @Private
    DatabaseBasedDataSetPathInfoProvider(IPathInfoDAO dao) {
        this.dao = dao;
    }

    @Override
    public List<DataSetPathInfo> listPathInfosByRegularExpression(String dataSetCode, final String regularExpression) {
        return new Loader(dataSetCode, new ILoader(){

            @Override
            public List<DataSetFileRecord> listDataSetFiles(long dataSetId) {
                String likeExpressionOrNull = DBUtils.tryToTranslateRegExpToLikePattern("^" + regularExpression + "$");
                if (likeExpressionOrNull == null) {
                    return DatabaseBasedDataSetPathInfoProvider.this.getDao().listDataSetFilesByRelativePathRegex(dataSetId, "^" + regularExpression + "$");
                }
                return DatabaseBasedDataSetPathInfoProvider.this.getDao().listDataSetFilesByRelativePathLikeExpression(dataSetId, likeExpressionOrNull);
            }
        }).getInfos();
    }

    @Override
    public DataSetPathInfo tryGetFullDataSetRootPathInfo(String dataSetCode) {
        return new Loader(dataSetCode, new ILoader(){

            @Override
            public List<DataSetFileRecord> listDataSetFiles(long dataSetId) {
                return DatabaseBasedDataSetPathInfoProvider.this.getDao().listDataSetFiles(dataSetId);
            }
        }).getRoot();
    }

    @Override
    public ISingleDataSetPathInfoProvider tryGetSingleDataSetPathInfoProvider(String dataSetCode) {
        Long dataSetId = this.getDao().tryToGetDataSetId(dataSetCode);
        if (dataSetId != null) {
            return new SingleDataSetPathInfoProvider(dataSetId, this.getDao());
        }
        return null;
    }

    private IPathInfoDAO getDao() {
        if (this.dao == null) {
            this.dao = (IPathInfoDAO)QueryTool.getQuery((DataSource)PathInfoDataSourceProvider.getDataSource(), IPathInfoDAO.class);
        }
        return this.dao;
    }

    private static String prepareDBStyleRegex(String pattern) {
        return "^" + pattern + "$";
    }

    @Private
    public static final class DataSetFileRecord {
        public long id;
        public Long parent_id;
        public String relative_path;
        public String file_name;
        public long size_in_bytes;
        public Integer checksum_crc32;
        public boolean is_directory;
        public Date last_modified;
    }

    private static interface ILoader {
        public List<DataSetFileRecord> listDataSetFiles(long var1);
    }

    @Private
    static interface IPathInfoDAO
    extends BaseQuery {
        public static final String SELECT_DATA_SET_FILES = "SELECT id, parent_id, relative_path, file_name, size_in_bytes, checksum_crc32, is_directory, last_modified FROM data_set_files ";

        @Select(value="SELECT id FROM data_sets WHERE code = ?{1}")
        public Long tryToGetDataSetId(String var1);

        @Select(value="SELECT id, parent_id, relative_path, file_name, size_in_bytes, checksum_crc32, is_directory, last_modified FROM data_set_files WHERE dase_id = ?{1}")
        public List<DataSetFileRecord> listDataSetFiles(long var1);

        @Select(value="SELECT id, parent_id, relative_path, file_name, size_in_bytes, checksum_crc32, is_directory, last_modified FROM data_set_files WHERE dase_id = ?{1} AND parent_id is null")
        public DataSetFileRecord getDataSetRootFile(long var1);

        @Select(value="SELECT id, parent_id, relative_path, file_name, size_in_bytes, checksum_crc32, is_directory, last_modified FROM data_set_files WHERE dase_id = ?{1} AND relative_path = ?{2}")
        public DataSetFileRecord tryToGetRelativeDataSetFile(long var1, String var3);

        @Select(value="SELECT id, parent_id, relative_path, file_name, size_in_bytes, checksum_crc32, is_directory, last_modified FROM data_set_files WHERE dase_id = ?{1} AND parent_id = ?{2}")
        public List<DataSetFileRecord> listChildrenByParentId(long var1, long var3);

        @Select(value="SELECT id, parent_id, relative_path, file_name, size_in_bytes, checksum_crc32, is_directory, last_modified FROM data_set_files WHERE dase_id = ?{1} AND relative_path ~ ?{2}")
        public List<DataSetFileRecord> listDataSetFilesByRelativePathRegex(long var1, String var3);

        @Select(value="SELECT id, parent_id, relative_path, file_name, size_in_bytes, checksum_crc32, is_directory, last_modified FROM data_set_files WHERE dase_id = ?{1} AND relative_path LIKE ?{2}")
        public List<DataSetFileRecord> listDataSetFilesByRelativePathLikeExpression(long var1, String var3);

        @Select(value="SELECT id, parent_id, relative_path, file_name, size_in_bytes, checksum_crc32, is_directory, last_modified FROM data_set_files WHERE dase_id = ?{1} AND relative_path = '?{2}' AND file_name ~ ?{3}")
        public List<DataSetFileRecord> listDataSetFilesByFilenameRegex(long var1, String var3, String var4);

        @Select(value="SELECT id, parent_id, relative_path, file_name, size_in_bytes, checksum_crc32, is_directory, last_modified FROM data_set_files WHERE dase_id = ?{1} AND relative_path = '?{2}' AND file_name LIKE ?{3}")
        public List<DataSetFileRecord> listDataSetFilesByFilenameLikeExpression(long var1, String var3, String var4);
    }

    private final class Loader {
        private Map<Long, DataSetPathInfo> idToInfoMap = new HashMap<Long, DataSetPathInfo>();
        private DataSetPathInfo root;

        Loader(String dataSetCode, ILoader loader) {
            Long dataSetId = DatabaseBasedDataSetPathInfoProvider.this.getDao().tryToGetDataSetId(dataSetCode);
            if (dataSetId != null) {
                List<DataSetFileRecord> dataSetFileRecords = loader.listDataSetFiles(dataSetId);
                HashMap<Long, List<DataSetPathInfo>> parentChildrenMap = new HashMap<Long, List<DataSetPathInfo>>();
                for (DataSetFileRecord dataSetFileRecord : dataSetFileRecords) {
                    DataSetPathInfo dataSetPathInfo = new DataSetPathInfo();
                    dataSetPathInfo.setFileName(dataSetFileRecord.file_name);
                    dataSetPathInfo.setRelativePath(dataSetFileRecord.relative_path);
                    dataSetPathInfo.setDirectory(dataSetFileRecord.is_directory);
                    dataSetPathInfo.setSizeInBytes(dataSetFileRecord.size_in_bytes);
                    dataSetPathInfo.setChecksumCRC32(dataSetFileRecord.checksum_crc32);
                    dataSetPathInfo.setLastModified(dataSetFileRecord.last_modified);
                    this.idToInfoMap.put(dataSetFileRecord.id, dataSetPathInfo);
                    Long parentId = dataSetFileRecord.parent_id;
                    if (parentId == null) {
                        this.root = dataSetPathInfo;
                        continue;
                    }
                    ArrayList<DataSetPathInfo> children = (ArrayList<DataSetPathInfo>)parentChildrenMap.get(parentId);
                    if (children == null) {
                        children = new ArrayList<DataSetPathInfo>();
                        parentChildrenMap.put(parentId, children);
                    }
                    children.add(dataSetPathInfo);
                }
                this.linkParentsWithChildren(parentChildrenMap);
            }
        }

        private void linkParentsWithChildren(Map<Long, List<DataSetPathInfo>> parentChildrenMap) {
            for (Map.Entry<Long, List<DataSetPathInfo>> entry : parentChildrenMap.entrySet()) {
                Long parentId = entry.getKey();
                DataSetPathInfo parent = this.idToInfoMap.get(parentId);
                if (parent == null) continue;
                List<DataSetPathInfo> children = entry.getValue();
                for (DataSetPathInfo child : children) {
                    parent.addChild(child);
                    child.setParent(parent);
                }
            }
        }

        DataSetPathInfo getRoot() {
            return this.root;
        }

        List<DataSetPathInfo> getInfos() {
            return new ArrayList<DataSetPathInfo>(this.idToInfoMap.values());
        }
    }

    static class SingleDataSetPathInfoProvider
    implements ISingleDataSetPathInfoProvider {
        private final Long dataSetId;
        private final IPathInfoDAO dao;

        public SingleDataSetPathInfoProvider(Long dataSetId, IPathInfoDAO dao) {
            this.dataSetId = dataSetId;
            this.dao = dao;
        }

        @Override
        public DataSetPathInfo getRootPathInfo() {
            DataSetFileRecord record = this.dao.getDataSetRootFile(this.dataSetId);
            if (record != null) {
                return this.asPathInfo(record);
            }
            throw new IllegalStateException("root path wasn't found");
        }

        @Override
        public DataSetPathInfo tryGetPathInfoByRelativePath(String relativePath) {
            String normalizedRelativePath = relativePath.replaceAll("/+", "/");
            DataSetFileRecord record = this.dao.tryToGetRelativeDataSetFile(this.dataSetId, normalizedRelativePath);
            if (record != null) {
                return this.asPathInfo(record);
            }
            return null;
        }

        @Override
        public List<DataSetPathInfo> listChildrenPathInfos(DataSetPathInfo parent) {
            List<DataSetFileRecord> records = this.dao.listChildrenByParentId(this.dataSetId, parent.getId());
            return this.asPathInfos(records);
        }

        @Override
        public List<DataSetPathInfo> listMatchingPathInfos(String relativePathPattern) {
            String likeExpressionOrNull = DBUtils.tryToTranslateRegExpToLikePattern(DatabaseBasedDataSetPathInfoProvider.prepareDBStyleRegex(relativePathPattern));
            List<DataSetFileRecord> records = likeExpressionOrNull == null ? this.dao.listDataSetFilesByRelativePathRegex(this.dataSetId, DatabaseBasedDataSetPathInfoProvider.prepareDBStyleRegex(relativePathPattern)) : this.dao.listDataSetFilesByRelativePathLikeExpression(this.dataSetId, likeExpressionOrNull);
            return this.asPathInfos(records);
        }

        @Override
        public List<DataSetPathInfo> listMatchingPathInfos(String startingPath, String fileNamePattern) {
            String likeExpressionOrNull = DBUtils.tryToTranslateRegExpToLikePattern(DatabaseBasedDataSetPathInfoProvider.prepareDBStyleRegex(fileNamePattern));
            List<DataSetFileRecord> records = likeExpressionOrNull == null ? this.dao.listDataSetFilesByFilenameRegex(this.dataSetId, startingPath, DatabaseBasedDataSetPathInfoProvider.prepareDBStyleRegex(fileNamePattern)) : this.dao.listDataSetFilesByFilenameLikeExpression(this.dataSetId, startingPath, likeExpressionOrNull);
            return this.asPathInfos(records);
        }

        private DataSetPathInfo asPathInfo(DataSetFileRecord record) {
            DataSetPathInfo result = new DataSetPathInfo();
            result.setId(record.id);
            result.setFileName(record.file_name);
            result.setRelativePath(record.relative_path);
            result.setDirectory(record.is_directory);
            result.setSizeInBytes(record.size_in_bytes);
            result.setChecksumCRC32(record.checksum_crc32);
            result.setLastModified(record.last_modified);
            return result;
        }

        private List<DataSetPathInfo> asPathInfos(List<DataSetFileRecord> records) {
            ArrayList<DataSetPathInfo> results = new ArrayList<DataSetPathInfo>();
            for (DataSetFileRecord record : records) {
                results.add(this.asPathInfo(record));
            }
            return results;
        }
    }
}

