/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.proteomics.server.plugins;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.ExceptionWithStatus;
import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.filesystem.BooleanStatus;
import ch.systemsx.cisd.common.filesystem.FileOperations;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.filesystem.IPathCopier;
import ch.systemsx.cisd.common.filesystem.highwatermark.HostAwareFileWithHighwaterMark;
import ch.systemsx.cisd.common.filesystem.ssh.ISshCommandExecutor;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.openbis.dss.generic.server.IDataSetFileOperationsExecutor;
import ch.systemsx.cisd.openbis.dss.generic.server.LocalDataSetFileOperationsExcecutor;
import ch.systemsx.cisd.openbis.dss.generic.server.RemoteDataSetFileOperationsExecutor;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.Copier;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.IPathCopierFactory;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.ISshCommandExecutorFactory;
import ch.systemsx.cisd.openbis.dss.generic.shared.IPostRegistrationDatasetHandler;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

class LocalAndRemoteCopier
implements Serializable,
IPostRegistrationDatasetHandler {
    @Private
    static final String MARKER_FILE_PREFIX = "marker-file-prefix";
    @Private
    static final String SAMPLE_UNKNOWN = "sample-unknown";
    private static final long serialVersionUID = 1L;
    static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, LocalAndRemoteCopier.class);
    private final Properties properties;
    private final IPathCopierFactory pathCopierFactory;
    private final ISshCommandExecutorFactory sshCommandExecutorFactory;
    private transient IDataSetFileOperationsExecutor executor;
    private transient String destination;
    private String markerFilePrefix;

    LocalAndRemoteCopier(Properties properties, IPathCopierFactory pathCopierFactory, ISshCommandExecutorFactory sshCommandExecutorFactory) {
        this.properties = properties;
        this.pathCopierFactory = pathCopierFactory;
        this.sshCommandExecutorFactory = sshCommandExecutorFactory;
        this.markerFilePrefix = properties.getProperty(MARKER_FILE_PREFIX);
        if (this.markerFilePrefix != null && this.markerFilePrefix.length() == 0) {
            throw new ConfigurationFailureException("marker-file-prefix is an empty string.");
        }
        this.init();
    }

    private void init() {
        String hostFile = PropertyUtils.getMandatoryProperty(this.properties, "destination");
        HostAwareFileWithHighwaterMark hostAwareFile = HostAwareFileWithHighwaterMark.create(hostFile, -1L);
        String hostOrNull = hostAwareFile.tryGetHost();
        this.destination = hostAwareFile.getPath();
        if (hostOrNull == null) {
            File sshExecutable = null;
            File rsyncExecutable = Copier.getExecutable(this.properties, "rsync");
            IPathCopier copier = this.pathCopierFactory.create(rsyncExecutable, sshExecutable, 15000L);
            copier.check();
            String rsyncModule = hostAwareFile.tryGetRsyncModule();
            String rsyncPasswordFile = this.properties.getProperty("rsync-password-file");
            this.executor = new LocalDataSetFileOperationsExcecutor(FileOperations.getMonitoredInstanceForCurrentThread(), copier, rsyncModule, rsyncPasswordFile);
        } else {
            File sshExecutable = Copier.getExecutable(this.properties, "ssh");
            File rsyncExecutable = Copier.getExecutable(this.properties, "rsync");
            File gfindExecutable = Copier.getExecutable(this.properties, "find");
            IPathCopier copier = this.pathCopierFactory.create(rsyncExecutable, sshExecutable, 15000L);
            copier.check();
            String rsyncModule = hostAwareFile.tryGetRsyncModule();
            String rsyncPasswordFile = this.properties.getProperty("rsync-password-file");
            FileUtilities.checkPathCopier(copier, hostOrNull, null, rsyncModule, rsyncPasswordFile, 15000L);
            ISshCommandExecutor sshCommandExecutor = this.sshCommandExecutorFactory.create(sshExecutable, hostOrNull);
            this.executor = new RemoteDataSetFileOperationsExecutor(sshCommandExecutor, copier, gfindExecutable, hostOrNull, rsyncModule, rsyncPasswordFile, 15000L);
        }
    }

    @Override
    public void undoLastOperation() {
    }

    @Override
    public Status handle(File originalData, DataSetInformation dataSetInformation, Map<String, String> parameterBindings) {
        if (this.destination == null) {
            this.init();
        }
        try {
            File destinationLocalFile = new File(this.destination);
            String target = dataSetInformation.getDataSetCode();
            File targetFolder = new File(destinationLocalFile, target);
            this.deleteTargetFolder(targetFolder);
            this.executor.copyDataSetToDestination(originalData, destinationLocalFile);
            this.executor.renameTo(targetFolder, new File(this.destination, originalData.getName()));
            if (this.markerFilePrefix != null) {
                this.executor.createMarkerFile(new File(this.destination, String.valueOf(this.markerFilePrefix) + target));
            }
            return Status.OK;
        }
        catch (ExceptionWithStatus ex) {
            return ex.getStatus();
        }
    }

    private void deleteTargetFolder(File targetFolder) {
        BooleanStatus targetExists = this.executor.exists(targetFolder);
        if (targetExists.isError()) {
            operationLog.error((Object)("Could not check existence of '" + targetFolder + "': " + targetExists.tryGetMessage()));
            throw new ExceptionWithStatus(Status.createError("couldn't check existence"));
        }
        if (targetExists.isSuccess()) {
            this.executor.deleteFolder(targetFolder);
        }
    }
}

