/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.etlserver.proteomics;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.etlserver.proteomics.dto.ProteinAnnotation;

final class ProteinDescription {
    static final String DESCRIPTION_KEY = "DE";
    static final String SEQUENCE_KEY = "SEQ";
    private String accessionNumber;
    private String description;
    private String sequence;

    static String createKeyValuePair(String key, String value) {
        return "\\" + key + "=" + value;
    }

    public ProteinDescription(ProteinAnnotation annotation, long proteinID, boolean assumingExtendedProtXML) {
        String proteinDescription = annotation.getDescription();
        String[] items = proteinDescription.split("\\\\");
        this.accessionNumber = this.tryToGetAccessionNumber(items);
        this.description = this.tryToGetValue(items, DESCRIPTION_KEY);
        this.sequence = this.tryToGetValue(items, SEQUENCE_KEY);
        if (this.sequence == null) {
            if (assumingExtendedProtXML) {
                throw new UserFailureException("Can not find a amino-acid sequence in following protein description: " + proteinDescription);
            }
            this.sequence = "";
            this.accessionNumber = this.getAccessionNumber(annotation, proteinID);
        }
        if (this.description == null && !assumingExtendedProtXML) {
            this.description = proteinDescription;
        }
    }

    private String getAccessionNumber(ProteinAnnotation annotation, long proteinID) {
        if (annotation.getSwissprotName() != null) {
            return "sp|" + annotation.getSwissprotName();
        }
        if (annotation.getTremblName() != null) {
            return "tr|" + annotation.getTremblName();
        }
        if (annotation.getIpiName() != null) {
            return "ipi|" + annotation.getIpiName();
        }
        if (annotation.getEnsemblName() != null) {
            return "ens|" + annotation.getEnsemblName();
        }
        if (annotation.getRefseqName() != null) {
            return "rs|" + annotation.getRefseqName();
        }
        if (annotation.getLocusLinkName() != null) {
            return "ll|" + annotation.getLocusLinkName();
        }
        if (annotation.getFlybase() != null) {
            return "fb|" + annotation.getFlybase();
        }
        return "unknown|" + proteinID;
    }

    public final String getAccessionNumber() {
        return this.accessionNumber;
    }

    public final String getDescription() {
        return this.description;
    }

    public final String getSequence() {
        return this.sequence;
    }

    private String tryToGetAccessionNumber(String[] items) {
        return items == null || items.length == 0 ? null : items[0].trim();
    }

    private String tryToGetValue(String[] items, String key) {
        String[] stringArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            int indexOfEqualSign = item.indexOf(61);
            if (indexOfEqualSign > 0 && item.substring(0, indexOfEqualSign).trim().equalsIgnoreCase(key)) {
                return item.substring(indexOfEqualSign + 1).trim();
            }
            ++n2;
        }
        return null;
    }
}

