/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.locator;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.ComponentProvider;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DispatcherHelper;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.locator.AbstractViewLocatorResolver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.locator.ViewLocator;
import ch.systemsx.cisd.openbis.generic.client.web.client.exception.UserFailureException;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;

public class BrowserLocatorResolver
extends AbstractViewLocatorResolver {
    private final IViewContext<ICommonClientServiceAsync> viewContext;
    public static final String BROWSE_ACTION = "BROWSE";
    public static final String TYPE_PARAMETER_KEY = "type";
    public static final String SPACE_PARAMETER_KEY = "space";
    public static final String PROJECT_PARAMETER_KEY = "project";

    public BrowserLocatorResolver(IViewContext<ICommonClientServiceAsync> viewContext) {
        super(BROWSE_ACTION);
        this.viewContext = viewContext;
    }

    @Override
    public void resolve(ViewLocator locator) throws UserFailureException {
        EntityKind entityKind = BrowserLocatorResolver.getEntityKind(locator);
        String entityTypeOrNull = locator.getParameters().get(TYPE_PARAMETER_KEY);
        String spaceOrNull = locator.getParameters().get(SPACE_PARAMETER_KEY);
        String projectOrNull = locator.getParameters().get(PROJECT_PARAMETER_KEY);
        switch (entityKind) {
            case EXPERIMENT: {
                this.openExperimentBrowser(spaceOrNull, projectOrNull, entityTypeOrNull);
                break;
            }
            case SAMPLE: {
                this.openSampleBrowser(spaceOrNull, entityTypeOrNull);
                break;
            }
            case MATERIAL: {
                this.openMaterialBrowser(entityTypeOrNull);
                break;
            }
            default: {
                throw new UserFailureException("Browsing " + entityKind.getDescription() + "s using URLs is not supported.");
            }
        }
    }

    private void openExperimentBrowser(String initialSpaceOrNull, String initialProjectOrNull, String initialExperimentTypeOrNull) {
        DispatcherHelper.dispatchNaviEvent(new ComponentProvider(this.viewContext).getExperimentBrowser(initialSpaceOrNull, initialProjectOrNull, initialExperimentTypeOrNull));
    }

    private void openSampleBrowser(String initialGroupOrNull, String initialSampleTypeOrNull) {
        DispatcherHelper.dispatchNaviEvent(new ComponentProvider(this.viewContext).getSampleBrowser(initialGroupOrNull, initialSampleTypeOrNull));
    }

    private void openMaterialBrowser(String initialMaterialTypeOrNull) {
        DispatcherHelper.dispatchNaviEvent(new ComponentProvider(this.viewContext).getMaterialBrowser(initialMaterialTypeOrNull));
    }
}

