/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.locator;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.URLListEncoder;
import java.io.UnsupportedEncodingException;

public class MaterialCodeUtils {
    public static String decode(String materialCode) {
        return MaterialCodeUtils.decodeWithoutExceptions(materialCode);
    }

    public static String[] decodeList(String materialCodesList) {
        String[] materialCodes = URLListEncoder.decodeItemList(materialCodesList);
        int i = 0;
        while (i < materialCodes.length) {
            materialCodes[i] = MaterialCodeUtils.decode(materialCodes[i]);
            ++i;
        }
        return materialCodes;
    }

    private static String decodeWithoutExceptions(String s) {
        StringBuilder sb = new StringBuilder();
        int numChars = s.length();
        int pos = 0;
        block6: while (pos < numChars) {
            char ch = s.charAt(pos);
            switch (ch) {
                case '%': {
                    try {
                        int i = 0;
                        int tmpPos = pos;
                        byte[] bytes = new byte[(numChars - pos) / 3];
                        while (tmpPos + 2 < numChars && ch == '%') {
                            bytes[i++] = (byte)Integer.parseInt(s.substring(tmpPos + 1, tmpPos + 3), 16);
                            if ((tmpPos += 3) >= numChars) continue;
                            ch = s.charAt(tmpPos);
                        }
                        if (tmpPos < numChars && ch == '%') {
                            ++pos;
                            sb.append('%');
                            break;
                        }
                        pos = tmpPos;
                        sb.append(new String(bytes, 0, i, "UTF-8"));
                    }
                    catch (NumberFormatException numberFormatException) {
                        sb.append('%');
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {}
                    continue block6;
                }
                default: {
                    ++pos;
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }
}

