/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.util;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IMessageProvider;
import java.util.ArrayList;
import java.util.List;

public final class CompositeMessageProvider
implements IMessageProvider {
    private static final String TRUE = "true";
    private static final String IS_DEFAULT_DICTIONARY = "is_default_dictionary";
    private final List<IMessageProvider> messageProviders = new ArrayList<IMessageProvider>();
    private String name;

    public void add(IMessageProvider messageProvider) {
        this.messageProviders.add(messageProvider);
    }

    @Override
    public String getName() {
        if (this.name == null) {
            StringBuffer buffer = new StringBuffer();
            for (IMessageProvider messageProvider : this.messageProviders) {
                if (buffer.length() > 0) {
                    buffer.append(", ");
                }
                buffer.append(messageProvider.getName());
            }
            this.name = "[" + buffer.toString() + "]";
        }
        return this.name;
    }

    @Override
    public final boolean containsKey(String key) {
        for (IMessageProvider messageProvider : this.messageProviders) {
            if (!messageProvider.containsKey(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final String getMessage(String key, Object ... parameters) {
        IMessageProvider defaultMessageProvider = this.tryGetDefaultDictionary(key);
        if (defaultMessageProvider != null && defaultMessageProvider.containsKey(key)) {
            return defaultMessageProvider.getMessage(key, parameters);
        }
        for (IMessageProvider messageProvider : this.messageProviders) {
            if (!messageProvider.containsKey(key)) continue;
            return messageProvider.getMessage(key, parameters);
        }
        return "Unknown key '" + key + "' in dictonaries " + this.getName() + ".";
    }

    private IMessageProvider tryGetDefaultDictionary(String key) {
        for (IMessageProvider messageProvider : this.messageProviders) {
            String isDefaultMsg;
            if (!messageProvider.containsKey(IS_DEFAULT_DICTIONARY) || (isDefaultMsg = messageProvider.getMessage(IS_DEFAULT_DICTIONARY, new Object[0])).compareToIgnoreCase(TRUE) != 0) continue;
            return messageProvider;
        }
        return null;
    }
}

