/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.server;

import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import ch.systemsx.cisd.openbis.common.spring.IUncheckedMultipartFile;
import ch.systemsx.cisd.openbis.common.spring.MultipartFileAdapter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.springframework.web.multipart.MultipartFile;

public final class UploadedFilesBean {
    private static final String CLASS_SIMPLE_NAME = UploadedFilesBean.class.getSimpleName();
    private List<IUncheckedMultipartFile> multipartFiles = new ArrayList<IUncheckedMultipartFile>();

    private final File createTempFile() throws IOException {
        File tempFile = File.createTempFile(CLASS_SIMPLE_NAME, null);
        tempFile.deleteOnExit();
        return tempFile;
    }

    public final void addMultipartFile(MultipartFile multipartFile) {
        assert (multipartFile != null) : "Unspecified multipart file.";
        try {
            File tempFile = this.createTempFile();
            multipartFile.transferTo(tempFile);
            FileMultipartFileAdapter multipartFileAdapter = new FileMultipartFileAdapter(multipartFile, tempFile);
            this.multipartFiles.add(multipartFileAdapter);
        }
        catch (IOException ex) {
            throw new IOExceptionUnchecked(ex);
        }
    }

    public final Iterable<IUncheckedMultipartFile> iterable() {
        return this.multipartFiles;
    }

    public final int size() {
        return this.multipartFiles.size();
    }

    public final void deleteTransferredFiles() {
        for (IUncheckedMultipartFile multipartFile : this.iterable()) {
            ((FileMultipartFileAdapter)multipartFile).destFile.delete();
        }
    }

    private static final class FileMultipartFileAdapter
    extends MultipartFileAdapter {
        private final File destFile;

        FileMultipartFileAdapter(MultipartFile multipartFile, File destFile) {
            super(multipartFile);
            this.destFile = destFile;
        }

        @Override
        public final byte[] getBytes() {
            try {
                return FileUtils.readFileToByteArray((File)this.destFile);
            }
            catch (IOException ex) {
                throw new IOExceptionUnchecked(ex);
            }
        }

        @Override
        public final InputStream getInputStream() {
            try {
                return FileUtils.openInputStream((File)this.destFile);
            }
            catch (IOException ex) {
                throw new IOExceptionUnchecked(ex);
            }
        }

        @Override
        public final void transferTo(File dest) {
            throw new UnsupportedOperationException();
        }
    }
}

