/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server;

import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.WebAppSettings;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DisplaySettings;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import java.util.HashMap;
import java.util.Map;

public class DisplaySettingsProvider {
    private final Map<String, DisplaySettings> displaySettingsMap = new HashMap<String, DisplaySettings>();

    public synchronized void addDisplaySettingsForPerson(PersonPE person) {
        DisplaySettings settings = this.displaySettingsMap.get(person.getUserId());
        if (settings == null) {
            settings = person.getDisplaySettings();
            this.displaySettingsMap.put(person.getUserId(), settings);
        }
    }

    public synchronized DisplaySettings getCurrentDisplaySettings(PersonPE person) {
        DisplaySettings settings = this.displaySettingsMap.get(person.getUserId());
        if (settings == null) {
            settings = person.getDisplaySettings();
            this.displaySettingsMap.put(person.getUserId(), settings);
        }
        settings = new DisplaySettings(settings);
        return settings;
    }

    public synchronized DisplaySettings getRegularDisplaySettings(PersonPE person) {
        DisplaySettings settings = this.displaySettingsMap.get(person.getUserId());
        if (settings == null) {
            settings = person.getDisplaySettings();
            this.displaySettingsMap.put(person.getUserId(), settings);
        }
        settings = new DisplaySettings(settings);
        settings.clearCustomWebAppSettings();
        return settings;
    }

    public synchronized DisplaySettings replaceCurrentDisplaySettings(PersonPE person, DisplaySettings settings) {
        this.displaySettingsMap.put(person.getUserId(), settings);
        person.setDisplaySettings(settings);
        return settings;
    }

    public synchronized DisplaySettings replaceRegularDisplaySettings(PersonPE person, DisplaySettings settings) {
        DisplaySettings oldSettings = this.displaySettingsMap.get(person.getUserId());
        if (oldSettings != null) {
            settings.overwriteCustomWebAppSettings(oldSettings);
            settings.overwriteColumnSettings(oldSettings);
        }
        this.displaySettingsMap.put(person.getUserId(), settings);
        person.setDisplaySettings(settings);
        return settings;
    }

    public synchronized WebAppSettings getWebAppSettings(PersonPE person, String webAppId) {
        DisplaySettings settings = this.displaySettingsMap.get(person.getUserId());
        if (settings == null) {
            settings = person.getDisplaySettings();
            this.displaySettingsMap.put(person.getUserId(), settings);
        }
        return new WebAppSettings(webAppId, settings.getCustomWebAppSettings(webAppId));
    }

    public synchronized DisplaySettings replaceWebAppSettings(PersonPE person, WebAppSettings webAppSettings) {
        DisplaySettings settings = this.displaySettingsMap.get(person.getUserId());
        if (settings == null) {
            settings = person.getDisplaySettings();
            this.displaySettingsMap.put(person.getUserId(), settings);
        }
        settings.setCustomWebAppSettings(webAppSettings.getWebAppId(), webAppSettings.getSettings());
        person.setDisplaySettings(settings);
        return settings;
    }
}

