/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business.bo;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.jython.evaluator.EvaluatorException;
import ch.systemsx.cisd.openbis.generic.server.business.bo.AbstractBusinessObject;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IScriptBO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IScriptDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator.JythonDynamicPropertyCalculator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator.JythonEntityValidationCalculator;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IScriptUpdates;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PluginType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Script;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ScriptType;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityTypePropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ScriptPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.IManagedPropertyEvaluatorFactory;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.JythonManagedPropertyEvaluator;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataRetrievalFailureException;

public final class ScriptBO
extends AbstractBusinessObject
implements IScriptBO {
    private ScriptPE script;
    private final IScriptFactory scriptFactory;

    public ScriptBO(IDAOFactory daoFactory, Session session, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory) {
        this(daoFactory, session, new ScriptFactory(), managedPropertyEvaluatorFactory);
    }

    @Private
    ScriptBO(IDAOFactory daoFactory, Session session, IScriptFactory scriptFactory, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory) {
        super(daoFactory, session, managedPropertyEvaluatorFactory);
        this.scriptFactory = scriptFactory;
    }

    @Override
    public ScriptPE deleteByTechId(TechId groupId) throws UserFailureException {
        this.loadDataByTechId(groupId);
        try {
            this.getScriptDAO().delete(this.script);
            return this.script;
        }
        catch (DataAccessException ex) {
            ScriptBO.throwException(ex, String.format("Script '%s'", this.script.getName()));
            return null;
        }
    }

    @Override
    public void loadDataByTechId(TechId id) {
        try {
            this.script = (ScriptPE)this.getScriptDAO().getByTechId(id);
        }
        catch (DataRetrievalFailureException exception) {
            throw new UserFailureException(exception.getMessage());
        }
    }

    @Override
    public void save() throws UserFailureException {
        assert (this.script != null) : "Script not defined";
        try {
            this.checkScriptCompilation(this.script.getScriptType(), this.script.getPluginType(), this.script.getScript());
            this.getScriptDAO().createOrUpdate(this.script);
        }
        catch (DataAccessException e) {
            ScriptBO.throwException(e, "Script '" + this.script.getName() + "'");
        }
    }

    @Override
    public void define(Script newScript) throws UserFailureException {
        assert (newScript != null) : "Unspecified script.";
        this.script = this.scriptFactory.create();
        this.script.setDatabaseInstance(this.getHomeDatabaseInstance());
        this.script.setName(newScript.getName());
        this.script.setDescription(newScript.getDescription());
        this.script.setRegistrator(this.findPerson());
        this.script.setScript(newScript.getScript());
        this.script.setScriptType(newScript.getScriptType());
        this.script.setPluginType(newScript.getPluginType());
        this.script.setEntityKind(newScript.getEntityKind() == null ? null : (newScript.getEntityKind().length == 1 ? newScript.getEntityKind()[0] : null));
        this.script.setAvailable(true);
    }

    @Override
    public void tryDefineOrUpdateIfPossible(Script newScript) {
        assert (newScript != null) : "Script cannot be null";
        assert (newScript.getName() != null) : "Script name cannot be null";
        IScriptDAO scriptDAO = this.getScriptDAO();
        this.script = scriptDAO.tryFindByName(newScript.getName());
        if (this.script == null) {
            this.define(newScript);
            this.save();
        } else if (newScript.getPluginType() == this.script.getPluginType() && newScript.getScriptType() == this.script.getScriptType()) {
            this.script.setDescription(newScript.getDescription());
            this.script.setAvailable(newScript.isAvailable());
            this.script.setScript(newScript.getScript());
            this.script.setEntityKind(newScript.getEntityKind() == null ? null : (newScript.getEntityKind().length == 1 ? newScript.getEntityKind()[0] : null));
            this.save();
            if (this.script.isDynamic()) {
                this.scheduleDynamicPropertiesEvaluation();
            }
        } else {
            StringBuilder sb = new StringBuilder("Cannot register ");
            sb.append(newScript.getPluginType()).append(" ").append(newScript.getScriptType()).append(" plugin '").append(newScript.getName()).append("' because plugin of different kind with the same name already exists.");
            throw new IllegalArgumentException(sb.toString());
        }
    }

    @Override
    public void tryDeleteOrInvalidatePredeployedPlugin(String name, ScriptType scriptType) {
        assert (name != null) : "Script name cannot be null";
        assert (scriptType != null) : "Script type cannot be null";
        IScriptDAO scriptDAO = this.getScriptDAO();
        this.script = scriptDAO.tryFindByName(name);
        if (this.script != null) {
            if (this.script.getPluginType() == PluginType.PREDEPLOYED && this.script.getScriptType() == scriptType) {
                this.script.setAvailable(false);
                this.save();
            } else {
                StringBuilder sb = new StringBuilder("Cannot delete ");
                sb.append(scriptType).append(" plugin '").append(name).append("' because plugin of different kind with the same name already exists.");
                throw new IllegalArgumentException(sb.toString());
            }
        }
    }

    @Override
    public void update(IScriptUpdates updates) {
        this.loadDataByTechId(TechId.create(updates));
        if (!this.script.getModificationDate().equals(updates.getModificationDate())) {
            ScriptBO.throwModifiedEntityException("Plugin");
        }
        this.script.setName(updates.getName());
        this.script.setDescription(updates.getDescription());
        boolean scriptChanged = false;
        if (this.script.getScript() != updates.getScript() && !this.script.getScript().equals(updates.getScript())) {
            scriptChanged = true;
            this.script.setScript(updates.getScript());
            this.checkScriptCompilation(this.script.getScriptType(), this.script.getPluginType(), updates.getScript());
        }
        this.getScriptDAO().createOrUpdate(this.script);
        this.script.getScript();
        if (scriptChanged && this.script.isDynamic()) {
            this.scheduleDynamicPropertiesEvaluation();
        }
    }

    @Override
    public final ScriptPE getScript() throws IllegalStateException {
        if (this.script == null) {
            throw new IllegalStateException("Unloaded script.");
        }
        return this.script;
    }

    private void scheduleDynamicPropertiesEvaluation() {
        for (EntityTypePropertyTypePE assignment : this.script.getPropertyAssignments()) {
            this.getEntityPropertyTypeDAO(assignment.getEntityType().getEntityKind()).scheduleDynamicPropertiesEvaluation(assignment);
        }
    }

    private void checkScriptCompilation(ScriptType scriptType, PluginType pluginType, String scriptExpression) throws EvaluatorException {
        if (pluginType == PluginType.PREDEPLOYED) {
            return;
        }
        if (scriptType == ScriptType.MANAGED_PROPERTY) {
            new JythonManagedPropertyEvaluator(scriptExpression);
        } else if (scriptType == ScriptType.DYNAMIC_PROPERTY) {
            JythonDynamicPropertyCalculator calculator = JythonDynamicPropertyCalculator.create(scriptExpression);
            calculator.checkScriptCompilation();
        } else {
            JythonEntityValidationCalculator calculator = JythonEntityValidationCalculator.create(scriptExpression, null);
            calculator.checkScriptCompilation();
        }
    }

    @Private
    static interface IScriptFactory {
        public ScriptPE create();
    }

    private static class ScriptFactory
    implements IScriptFactory {
        private ScriptFactory() {
        }

        @Override
        public ScriptPE create() {
            return new ScriptPE();
        }
    }
}

