/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.db;

import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.logging.LogInitializer;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.IndexCreationUtil;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

public class DatabaseAndIndexReplacer {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, DatabaseAndIndexReplacer.class);

    public static void main(String[] args) {
        if (args.length != 4) {
            System.out.println("Usage: java " + DatabaseAndIndexReplacer.class.getName() + " <destination database kind> <destination index folder> " + "<source database kind> <source index folder>");
            System.exit(1);
        }
        LogInitializer.init();
        String destinationDatabase = "openbis_" + args[0];
        File destinationFolder = new File(args[1]);
        String sourceDatabase = "openbis_" + args[2];
        File sourceFolder = new File(args[3]);
        boolean ok = IndexCreationUtil.duplicateDatabase(destinationDatabase, sourceDatabase);
        if (!ok) {
            System.exit(1);
        }
        FileUtilities.deleteRecursively(destinationFolder);
        try {
            FileUtils.copyDirectory((File)sourceFolder, (File)destinationFolder, (boolean)true);
            operationLog.info((Object)("Index successfully copies from '" + sourceFolder + "' to '" + destinationFolder + "'."));
        }
        catch (IOException ex) {
            operationLog.error((Object)("Couldn't copy '" + sourceFolder + "' to '" + destinationFolder + "'."), (Throwable)ex);
        }
    }
}

