/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.db;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.reflection.MethodUtils;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IRelationshipTypeDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.AbstractGenericEntityDAO;
import ch.systemsx.cisd.openbis.generic.shared.basic.CodeConverter;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatabaseInstancePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.RelationshipTypePE;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.SessionFactory;

public class RelationshipTypeDAO
extends AbstractGenericEntityDAO<RelationshipTypePE>
implements IRelationshipTypeDAO {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, RelationshipTypeDAO.class);

    public RelationshipTypeDAO(SessionFactory sessionFactory, DatabaseInstancePE databaseInstance) {
        super(sessionFactory, databaseInstance, RelationshipTypePE.class);
    }

    @Override
    public RelationshipTypePE tryFindRelationshipTypeByCode(String code) {
        assert (code != null) : "Unspecified relationship type code";
        String mangledCode = CodeConverter.tryToDatabase(code);
        boolean internalNamespace = CodeConverter.isInternalNamespace(code);
        List list = RelationshipTypeDAO.cast(this.getHibernateTemplate().find(String.format("select pt from %s pt where pt.simpleCode = ? and pt.databaseInstance = ? and pt.internalNamespace = ?", RelationshipTypePE.class.getSimpleName()), RelationshipTypeDAO.toArray(mangledCode, this.getDatabaseInstance(), internalNamespace)));
        RelationshipTypePE entity = (RelationshipTypePE)RelationshipTypeDAO.tryFindEntity(list, "relationship type", code);
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("%s(%s): '%s'.", MethodUtils.getCurrentMethod().getName(), code, entity));
        }
        return entity;
    }
}

