/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.demo.client.web.client.application.module;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DatabaseModificationAwareComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.IDatabaseModificationObserver;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.plugin.demo.client.web.client.IDemoClientServiceAsync;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Html;
import com.google.gwt.user.client.Element;
import java.util.Set;

public class StatisticsWidget
extends ContentPanel
implements IDatabaseModificationObserver {
    protected static final String ID = "openbis_demo-module-statistics";
    private final IViewContext<IDemoClientServiceAsync> viewContext;
    private Html numberOfExperiments;

    private StatisticsWidget(IViewContext<IDemoClientServiceAsync> viewContext) {
        this.viewContext = viewContext;
        this.setHeading(viewContext.getMessage("statistics_tab_header", new Object[0]));
        this.numberOfExperiments = new Html();
        this.add((Component)this.numberOfExperiments);
    }

    public static DatabaseModificationAwareComponent create(IViewContext<IDemoClientServiceAsync> viewContext) {
        StatisticsWidget viewer = new StatisticsWidget(viewContext);
        return new DatabaseModificationAwareComponent((Component)viewer, (IDatabaseModificationObserver)viewer);
    }

    protected void onRender(Element parent, int pos) {
        super.onRender(parent, pos);
        this.refresh();
    }

    private void refresh() {
        this.viewContext.getService().getNumberOfExperiments(new ExperimentStatisticsCallback(this.viewContext, this.numberOfExperiments));
    }

    @Override
    public DatabaseModificationKind[] getRelevantModifications() {
        return new DatabaseModificationKind[]{DatabaseModificationKind.createOrDelete(DatabaseModificationKind.ObjectKind.EXPERIMENT)};
    }

    @Override
    public void update(Set<DatabaseModificationKind> observedModifications) {
        this.refresh();
    }

    private static final class ExperimentStatisticsCallback
    extends AbstractAsyncCallback<Integer> {
        private final Html target;

        private ExperimentStatisticsCallback(IViewContext<IDemoClientServiceAsync> viewContext, Html target) {
            super(viewContext);
            this.target = target;
        }

        @Override
        protected final void process(Integer result) {
            this.target.setHtml("Number of experiments: " + result);
        }
    }
}

