/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.generic.server;

import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewSample;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifier;

class IdentifersExtractor {
    private final SampleIdentifier oldSampleIdentifier;
    private final SampleIdentifier newSampleIdentifier;
    private final ExperimentIdentifier experimentIdentifierOrNull;
    private final String containerIdentifierOrNull;

    IdentifersExtractor(NewSample updatedSample) {
        this.oldSampleIdentifier = SampleIdentifierFactory.parse(updatedSample);
        if (updatedSample.getExperimentIdentifier() != null) {
            this.experimentIdentifierOrNull = new ExperimentIdentifierFactory(updatedSample.getExperimentIdentifier()).createIdentifier(updatedSample.getDefaultSpaceIdentifier());
            this.newSampleIdentifier = new SampleIdentifier(new SpaceIdentifier(this.experimentIdentifierOrNull.getDatabaseInstanceCode(), this.experimentIdentifierOrNull.getSpaceCode()), this.oldSampleIdentifier.getSampleCode());
        } else {
            this.experimentIdentifierOrNull = null;
            this.newSampleIdentifier = this.oldSampleIdentifier;
        }
        this.containerIdentifierOrNull = updatedSample.getContainerIdentifier();
    }

    public SampleIdentifier getOldSampleIdentifier() {
        return this.oldSampleIdentifier;
    }

    public SampleIdentifier getNewSampleIdentifier() {
        return this.newSampleIdentifier;
    }

    public ExperimentIdentifier getExperimentIdentifierOrNull() {
        return this.experimentIdentifierOrNull;
    }

    public String getContainerIdentifierOrNull() {
        return this.containerIdentifierOrNull;
    }
}

