/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.proteomics.client.web.client.application;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.DisposableTabContent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.VoidAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DatabaseModificationAwareComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.IDatabaseModificationObserver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.renderer.LinkRenderer;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.data.ProcessingDisplayCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IDisposableComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.lang.StringEscapeUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.DefaultResultSetConfig;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.DisplayedOrSelectedDatasetCriteria;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.ResultSet;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TypedTableResultSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.GridRowModel;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdAndCodeHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BasicEntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataStoreServiceKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatastoreServiceDescription;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.IGenericClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.GenericViewContext;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.experiment.GenericExperimentViewer;
import ch.systemsx.cisd.openbis.plugin.proteomics.client.web.client.IPhosphoNetXClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.proteomics.client.web.client.application.DisplayTypeIDGenerator;
import ch.systemsx.cisd.openbis.plugin.proteomics.client.web.client.application.ProteinByExperimentBrowserGrid;
import com.extjs.gxt.ui.client.util.Margins;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.extjs.gxt.ui.client.widget.layout.RowData;
import com.extjs.gxt.ui.client.widget.layout.RowLayout;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ExperimentViewer
extends GenericExperimentViewer {
    private final IViewContext<IPhosphoNetXClientServiceAsync> specificViewContext;

    public static DatabaseModificationAwareComponent create(IViewContext<IPhosphoNetXClientServiceAsync> viewContext, BasicEntityType experimentType, IIdAndCodeHolder experimentId) {
        ExperimentViewer viewer = new ExperimentViewer(new GenericViewContext(viewContext.getCommonViewContext()), viewContext, experimentType, experimentId);
        return new DatabaseModificationAwareComponent((Component)viewer, (IDatabaseModificationObserver)viewer);
    }

    protected ExperimentViewer(IViewContext<IGenericClientServiceAsync> viewContext, IViewContext<IPhosphoNetXClientServiceAsync> specificViewContext, BasicEntityType experimentType, IIdAndCodeHolder experimentId) {
        super(viewContext, experimentType, experimentId);
        this.specificViewContext = specificViewContext;
    }

    @Override
    protected List<DisposableTabContent> createAdditionalBrowserSectionPanels() {
        DisposableTabContent section = new DisposableTabContent(this.specificViewContext.getMessage("proteins_section", new Object[0]), this.specificViewContext, this.experiment){

            @Override
            protected IDisposableComponent createDisposableContent() {
                return ProteinByExperimentBrowserGrid.create(ExperimentViewer.this.specificViewContext, ExperimentViewer.this.experimentType, ExperimentViewer.this.experiment);
            }
        };
        section.setIds(DisplayTypeIDGenerator.PROTEIN_SECTION);
        return Collections.singletonList(section);
    }

    @Override
    protected Component tryCreateLowerLeftComponent() {
        if (this.viewContext.isSimpleOrEmbeddedMode()) {
            return null;
        }
        final ContentPanel contentPanel = new ContentPanel((Layout)new RowLayout());
        contentPanel.setHeading(this.viewContext.getMessage("data_set_processing_section_title", new Object[0]));
        this.viewContext.getCommonService().listExperimentDataSets(new TechId(this.experimentId), DefaultResultSetConfig.<String, TableModelRowWithObject<AbstractExternalData>>createFetchAll(), true, (AsyncCallback<TypedTableResultSet<AbstractExternalData>>)new AbstractAsyncCallback<TypedTableResultSet<AbstractExternalData>>(this.viewContext){

            @Override
            protected void process(TypedTableResultSet<AbstractExternalData> result) {
                AsyncCallback callBack = ExperimentViewer.this.createCallback(contentPanel, result);
                this.viewContext.getCommonService().listDataStoreServices(DataStoreServiceKind.PROCESSING, (AsyncCallback<List<DatastoreServiceDescription>>)callBack);
            }
        });
        return contentPanel;
    }

    private AsyncCallback<List<DatastoreServiceDescription>> createCallback(final ContentPanel contentPanel, TypedTableResultSet<AbstractExternalData> result) {
        ResultSet<TableModelRowWithObject<AbstractExternalData>> resultSet = result.getResultSet();
        String resultSetKey = resultSet.getResultSetKey();
        this.viewContext.getCommonService().removeResultSet(resultSetKey, new VoidAsyncCallback<Void>(this.viewContext));
        ArrayList<String> dataSetCodes = new ArrayList<String>();
        for (GridRowModel gridRowModel : resultSet.getList()) {
            dataSetCodes.add(((AbstractExternalData)((TableModelRowWithObject)gridRowModel.getOriginalObject()).getObjectOrNull()).getCode());
        }
        final DisplayedOrSelectedDatasetCriteria displayedOrSelectedDatasetCriteria = DisplayedOrSelectedDatasetCriteria.createSelectedItems(dataSetCodes);
        return new AbstractAsyncCallback<List<DatastoreServiceDescription>>(this.viewContext){

            @Override
            protected void process(List<DatastoreServiceDescription> descriptions) {
                for (DatastoreServiceDescription description : descriptions) {
                    String[] dataSetTypes;
                    String[] stringArray = dataSetTypes = description.getDatasetTypeCodes();
                    int n = dataSetTypes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String dataSetType = stringArray[n2];
                        if (dataSetType.equals("PROT_RESULT")) {
                            Widget link = ExperimentViewer.this.createLink(description, displayedOrSelectedDatasetCriteria);
                            LayoutContainer wrapper = new LayoutContainer((Layout)new FitLayout());
                            wrapper.add(link);
                            contentPanel.add((Widget)wrapper, (LayoutData)new RowData(1.0, -1.0, new Margins(5)));
                        }
                        ++n2;
                    }
                }
                contentPanel.layout();
            }
        };
    }

    private Widget createLink(final DatastoreServiceDescription description, final DisplayedOrSelectedDatasetCriteria criteria) {
        String href = "";
        ClickHandler listener = new ClickHandler(){

            public void onClick(ClickEvent event) {
                ExperimentViewer.this.viewContext.getCommonService().processDatasets(description, criteria, new ProcessingDisplayCallback(ExperimentViewer.this.viewContext));
            }
        };
        String label = StringEscapeUtils.unescapeHtml(description.getLabel());
        return LinkRenderer.getLinkWidget(label, listener, href);
    }
}

