/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.proteomics.client.web.client.application;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.TypedTableGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IDisposableComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.DefaultResultSetConfig;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TableExportCriteria;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TypedTableResultSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import ch.systemsx.cisd.openbis.plugin.proteomics.client.web.client.IPhosphoNetXClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.proteomics.client.web.client.application.PhosphoNetXDisplayTypeIDGenerator;
import ch.systemsx.cisd.openbis.plugin.proteomics.client.web.client.dto.ListProteinSequenceCriteria;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.basic.dto.ProteinSequence;
import java.util.Arrays;
import java.util.List;

public class ProteinSequenceGrid
extends TypedTableGrid<ProteinSequence> {
    private static final String PREFIX = "openbis_protein-sequence-browser";
    public static final String BROWSER_ID = "openbis_protein-sequence-browser_main";
    public static final String GRID_ID = "openbis_protein-sequence-browser-grid";
    private final IViewContext<IPhosphoNetXClientServiceAsync> specificViewContext;
    private ListProteinSequenceCriteria criteria;

    static IDisposableComponent create(IViewContext<IPhosphoNetXClientServiceAsync> viewContext, Experiment experimentOrNull, TechId proteinReferenceID) {
        return new ProteinSequenceGrid(viewContext, experimentOrNull, proteinReferenceID).asDisposableWithoutToolbar();
    }

    private ProteinSequenceGrid(IViewContext<IPhosphoNetXClientServiceAsync> viewContext, Experiment experimentOrNull, TechId proteinReferenceID) {
        super(viewContext.getCommonViewContext(), BROWSER_ID + proteinReferenceID, true, PhosphoNetXDisplayTypeIDGenerator.PROTEIN_SEQUENCE_BROWSER_GRID);
        this.specificViewContext = viewContext;
        this.criteria = new ListProteinSequenceCriteria();
        if (experimentOrNull != null) {
            this.criteria.setExperimentID(new TechId(experimentOrNull.getId()));
        }
        this.criteria.setProteinReferenceID(proteinReferenceID);
    }

    @Override
    protected String translateColumnIdToDictionaryKey(String columnID) {
        return columnID.toLowerCase();
    }

    @Override
    protected List<String> getColumnIdsOfFilters() {
        return Arrays.asList(new String[0]);
    }

    @Override
    protected void listTableRows(DefaultResultSetConfig<String, TableModelRowWithObject<ProteinSequence>> resultSetConfig, AbstractAsyncCallback<TypedTableResultSet<ProteinSequence>> callback) {
        this.criteria.copyPagingConfig(resultSetConfig);
        this.specificViewContext.getService().listSequencesByProteinReference(this.criteria, callback);
    }

    @Override
    protected void prepareExportEntities(TableExportCriteria<TableModelRowWithObject<ProteinSequence>> exportCriteria, AbstractAsyncCallback<String> callback) {
        this.specificViewContext.getService().prepareExportProteinSequences(exportCriteria, callback);
    }

    @Override
    public DatabaseModificationKind[] getRelevantModifications() {
        return new DatabaseModificationKind[0];
    }
}

