/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.proteomics.client.web.client.application.wizard;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.SampleTypeDisplayID;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.SampleTypeModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.SpaceSelectionWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.CodeFieldWithGenerator;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.ExperimentChooserField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.sample.SampleTypeSelectionWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.ClickableFormPanel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.FieldUtil;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.wizard.WizardPage;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleTypePropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.api.IManagedInputWidgetDescription;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.sample.AbstractGenericSampleRegisterEditForm;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.sample.SamplePropertyEditor;
import ch.systemsx.cisd.openbis.plugin.proteomics.client.web.client.IPhosphoNetXClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.proteomics.client.web.client.application.wizard.MsInjectionAnnotationWizardState;
import ch.systemsx.cisd.openbis.plugin.proteomics.client.web.client.application.wizard.MsInjectionSampleAnnotationModel;
import com.extjs.gxt.ui.client.event.SelectionChangedEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedListener;
import com.extjs.gxt.ui.client.util.Margins;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.extjs.gxt.ui.client.widget.layout.RowData;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Widget;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class BiologicalSampleCreatingPage
extends WizardPage<MsInjectionSampleAnnotationModel> {
    private final IViewContext<IPhosphoNetXClientServiceAsync> viewContext;
    private ClickableFormPanel formPanel;
    private SampleTypeSelectionWidget sampleTypeSelectionWidget;
    private SampleType sampleType;
    private CodeFieldWithGenerator codeField;
    private SpaceSelectionWidget spaceSelectionWidget;
    private SamplePropertyEditor samplePropertyEditor;
    private ExperimentChooserField.ExperimentChooserFieldAdaptor experimentField;
    private Map<String, List<IManagedInputWidgetDescription>> inputWidgetDescriptions = Collections.emptyMap();

    public BiologicalSampleCreatingPage(IViewContext<IPhosphoNetXClientServiceAsync> viewContext, MsInjectionSampleAnnotationModel model) {
        super(viewContext, MsInjectionAnnotationWizardState.BIOLOGICAL_SAMPLE_CREATING, model);
        this.viewContext = viewContext;
        this.setLeftContentByDictionary();
    }

    @Override
    public void init() {
        this.formPanel = new ClickableFormPanel();
        this.formPanel.setHeaderVisible(false);
        this.sampleTypeSelectionWidget = new SampleTypeSelectionWidget(this.viewContext, "bio-samp", true, SampleTypeDisplayID.SAMPLE_REGISTRATION, null){

            @Override
            protected void filterTypes(List<SampleType> types) {
                Iterator<SampleType> iterator = types.iterator();
                while (iterator.hasNext()) {
                    SampleType type = iterator.next();
                    if (type.getCode().startsWith("BIO")) continue;
                    iterator.remove();
                }
            }
        };
        this.sampleTypeSelectionWidget.addSelectionChangedListener((SelectionChangedListener)new SelectionChangedListener<SampleTypeModel>(){

            public void selectionChanged(SelectionChangedEvent<SampleTypeModel> se) {
                SampleType sampleTypeOrNull = BiologicalSampleCreatingPage.this.sampleTypeSelectionWidget.tryGetSelectedSampleType();
                if (sampleTypeOrNull != null) {
                    BiologicalSampleCreatingPage.this.onSampleTypeChanged(sampleTypeOrNull);
                }
            }
        });
        this.formPanel.add((Widget)this.sampleTypeSelectionWidget);
        this.addToRightContent((Component)this.formPanel, new RowData(1.0, 600.0, new Margins(10)));
    }

    protected void onSampleTypeChanged(SampleType type) {
        this.sampleType = type;
        this.formPanel.removeAll();
        this.formPanel.add((Widget)this.sampleTypeSelectionWidget);
        this.codeField = new CodeFieldWithGenerator(this.viewContext, this.viewContext.getMessage("code", new Object[0]), type.getGeneratedCodePrefix(), EntityKind.SAMPLE, type.isAutoGeneratedCode());
        boolean codeReadonly = type.isAutoGeneratedCode();
        this.codeField.setReadOnly(codeReadonly);
        this.codeField.setHideTrigger(codeReadonly);
        this.formPanel.add((Widget)this.codeField);
        List<SampleTypePropertyType> types = type.getAssignedPropertyTypes();
        this.spaceSelectionWidget = new SpaceSelectionWidget(this.viewContext, this.getId(), true, false, this.viewContext.getModel().getSessionContext().getUser().getHomeGroupCode());
        FieldUtil.markAsMandatory(this.spaceSelectionWidget);
        this.formPanel.add((Widget)this.spaceSelectionWidget);
        String label = this.viewContext.getMessage("experiment", new Object[0]);
        this.experimentField = ExperimentChooserField.create(label, false, null, this.viewContext.getCommonViewContext());
        this.formPanel.add((Widget)this.experimentField.getChooserField());
        this.samplePropertyEditor = new SamplePropertyEditor("bio-s", this.inputWidgetDescriptions, this.viewContext.getCommonViewContext());
        this.samplePropertyEditor.initWithoutProperties(types);
        this.samplePropertyEditor.addPropertyFieldsWithFieldsetToPanel(this.formPanel);
        this.formPanel.layout();
        this.formPanel.addClickListener(new ClickHandler(){

            public void onClick(ClickEvent event) {
                BiologicalSampleCreatingPage.this.enableNextButton(BiologicalSampleCreatingPage.this.formPanel.isValid());
            }
        });
    }

    @Override
    public void deactivate() {
        String identifier = AbstractGenericSampleRegisterEditForm.createSampleIdentifier(this.spaceSelectionWidget, (Field<String>)this.codeField);
        String experimentIdentifierOrNull = (String)this.experimentField.getChooserField().getValue();
        List<IEntityProperty> properties = this.samplePropertyEditor.extractProperties();
        ((MsInjectionSampleAnnotationModel)this.model).defineBiologicalSample(this.sampleType, identifier, experimentIdentifierOrNull, properties);
    }

    @Override
    public void destroy() {
        this.spaceSelectionWidget.dispose();
    }
}

