/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.proteomics.client.web.server;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.filesystem.SimpleFreeSpaceProvider;
import ch.systemsx.cisd.common.servlet.IRequestContextProvider;
import ch.systemsx.cisd.common.utilities.ITimeProvider;
import ch.systemsx.cisd.common.utilities.SystemTimeProvider;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.DefaultResultSetConfig;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.IResultSetConfig;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.ResultSet;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TableExportCriteria;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TypedTableResultSet;
import ch.systemsx.cisd.openbis.generic.client.web.client.exception.UserFailureException;
import ch.systemsx.cisd.openbis.generic.client.web.server.AbstractClientService;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.DataProviderAdapter;
import ch.systemsx.cisd.openbis.generic.shared.ICommonServer;
import ch.systemsx.cisd.openbis.generic.shared.IServer;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewAttachment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewSample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Vocabulary;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.WebClientConfiguration;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.util.CacheManager;
import ch.systemsx.cisd.openbis.generic.shared.util.Key;
import ch.systemsx.cisd.openbis.plugin.generic.shared.IGenericServer;
import ch.systemsx.cisd.openbis.plugin.proteomics.BuildAndEnvironmentInfo;
import ch.systemsx.cisd.openbis.plugin.proteomics.client.web.client.IPhosphoNetXClientService;
import ch.systemsx.cisd.openbis.plugin.proteomics.client.web.client.dto.ListProteinByExperimentAndReferenceCriteria;
import ch.systemsx.cisd.openbis.plugin.proteomics.client.web.client.dto.ListProteinByExperimentCriteria;
import ch.systemsx.cisd.openbis.plugin.proteomics.client.web.client.dto.ListProteinSequenceCriteria;
import ch.systemsx.cisd.openbis.plugin.proteomics.client.web.client.dto.ListProteinSummaryByExperimentCriteria;
import ch.systemsx.cisd.openbis.plugin.proteomics.client.web.client.dto.ListSampleAbundanceByProteinCriteria;
import ch.systemsx.cisd.openbis.plugin.proteomics.client.web.server.RawDataSampleProvider;
import ch.systemsx.cisd.openbis.plugin.proteomics.client.web.server.resultset.BiologicalSampleProvider;
import ch.systemsx.cisd.openbis.plugin.proteomics.client.web.server.resultset.DataSetProteinProvider;
import ch.systemsx.cisd.openbis.plugin.proteomics.client.web.server.resultset.ParentlessMsInjectionSampleProvider;
import ch.systemsx.cisd.openbis.plugin.proteomics.client.web.server.resultset.ProteinProvider;
import ch.systemsx.cisd.openbis.plugin.proteomics.client.web.server.resultset.ProteinRelatedSampleProvider;
import ch.systemsx.cisd.openbis.plugin.proteomics.client.web.server.resultset.ProteinSequenceProvider;
import ch.systemsx.cisd.openbis.plugin.proteomics.client.web.server.resultset.ProteinSummaryProvider;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.CacheData;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.IPhosphoNetXServer;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.IProteomicsDataServiceInternal;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.basic.dto.AbundanceColumnDefinition;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.basic.dto.AggregateFunction;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.basic.dto.DataSetProtein;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.basic.dto.ProteinByExperiment;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.basic.dto.ProteinInfo;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.basic.dto.ProteinRelatedSample;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.basic.dto.ProteinSequence;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.basic.dto.ProteinSummary;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.lang.time.StopWatch;
import org.springframework.aop.Advisor;
import org.springframework.aop.Pointcut;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.aop.support.annotation.AnnotationMatchingPointcut;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;

@Component(value="proteomics-plugin-service")
public class PhosphoNetXClientService
extends AbstractClientService
implements IPhosphoNetXClientService,
InitializingBean {
    private static final String CACHE_VERSION = Integer.toString(35);
    @Resource(name="common-server")
    private ICommonServer commonServer;
    @Resource(name="generic-plugin-server")
    private IGenericServer genericServer;
    @Resource(name="proteomics-plugin-server")
    @Private
    IPhosphoNetXServer server;
    @Resource(name="proteomics-data-service-web")
    private IProteomicsDataServiceInternal proteomicsDataService;
    @Private
    ITimeProvider timeProvider = SystemTimeProvider.SYSTEM_TIME_PROVIDER;

    public PhosphoNetXClientService() {
    }

    public PhosphoNetXClientService(IRequestContextProvider requestContextProvider) {
        super(requestContextProvider);
    }

    public void afterPropertiesSet() throws Exception {
        WebClientConfiguration webClientConfiguration = this.getWebClientConfiguration();
        SimpleFreeSpaceProvider freeSpaceProvider = new SimpleFreeSpaceProvider();
        final CacheManager cacheManager = new CacheManager(webClientConfiguration, "proteomics", this.timeProvider, freeSpaceProvider, CACHE_VERSION);
        ProxyFactory proxyFactory = new ProxyFactory((Object)this.server);
        proxyFactory.addInterface(IPhosphoNetXServer.class);
        AnnotationMatchingPointcut pointcut = AnnotationMatchingPointcut.forMethodAnnotation(CacheData.class);
        proxyFactory.addAdvisor((Advisor)new DefaultPointcutAdvisor((Pointcut)pointcut, (Advice)new MethodInterceptor(){

            public Object invoke(MethodInvocation methodInvocation) throws Throwable {
                Object[] arguments = methodInvocation.getArguments();
                Object[] keyArguments = new Serializable[arguments.length];
                Method method = methodInvocation.getMethod();
                keyArguments[0] = method.getName();
                int i = 1;
                while (i < keyArguments.length) {
                    keyArguments[i] = arguments[i];
                    ++i;
                }
                Key key = new Key(keyArguments);
                Object data = cacheManager.tryToGetData(key);
                if (data == null) {
                    Object serverObject = methodInvocation.getThis();
                    data = method.invoke(serverObject, arguments);
                    cacheManager.storeData(key, data);
                }
                return data;
            }
        }));
        this.server = (IPhosphoNetXServer)proxyFactory.getProxy();
    }

    @Override
    protected IServer getServer() {
        return this.server;
    }

    @Override
    protected String getVersion() {
        return BuildAndEnvironmentInfo.INSTANCE.getFullVersion();
    }

    @Override
    public TypedTableResultSet<Sample> listParentlessMsInjectionSamples(DefaultResultSetConfig<String, TableModelRowWithObject<Sample>> criteria) throws UserFailureException {
        String sessionToken = this.getSessionToken();
        return this.listEntities(new ParentlessMsInjectionSampleProvider(this.commonServer, sessionToken), criteria);
    }

    @Override
    public TypedTableResultSet<Sample> listBiologicalSamples(DefaultResultSetConfig<String, TableModelRowWithObject<Sample>> criteria) throws UserFailureException {
        String sessionToken = this.getSessionToken();
        return this.listEntities(new BiologicalSampleProvider(this.commonServer, sessionToken), criteria);
    }

    @Override
    public void linkSamples(Sample parentSample, List<Sample> childSamples) throws UserFailureException {
        String sessionToken = this.getSessionToken();
        this.linkSamples(sessionToken, parentSample.getIdentifier(), childSamples);
    }

    @Override
    public void createAndLinkSamples(NewSample newBiologicalSample, List<Sample> msInjectionSamples) throws UserFailureException {
        String sessionToken = this.getSessionToken();
        List<NewAttachment> noAttachments = Collections.emptyList();
        this.genericServer.registerSample(sessionToken, newBiologicalSample, noAttachments);
        this.linkSamples(sessionToken, newBiologicalSample.getIdentifier(), msInjectionSamples);
    }

    private void linkSamples(String sessionToken, String identifier, List<Sample> childSamples) {
        String[] parents = new String[]{identifier};
        for (Sample childSample : childSamples) {
            SampleIdentifier childSampleIdentifier = SampleIdentifierFactory.parse(childSample.getIdentifier());
            SampleUpdatesDTO update = new SampleUpdatesDTO(new TechId(childSample), Collections.<IEntityProperty>emptyList(), null, Collections.<NewAttachment>emptyList(), childSample.getVersion(), childSampleIdentifier, null, parents);
            update.setUpdateExperimentLink(false);
            this.genericServer.updateSample(sessionToken, update);
        }
    }

    @Override
    public Vocabulary getTreatmentTypeVocabulary() {
        String sessionToken = this.getSessionToken();
        return this.server.getTreatmentTypeVocabulary(sessionToken);
    }

    @Override
    public List<AbundanceColumnDefinition> getAbundanceColumnDefinitionsForProteinByExperiment(TechId experimentID, String treatmentTypeOrNull) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            String sessionToken = this.getSessionToken();
            List<AbundanceColumnDefinition> list = this.server.getAbundanceColumnDefinitionsForProteinByExperiment(sessionToken, experimentID, treatmentTypeOrNull);
            return list;
        }
        finally {
            operationLog.info((Object)(String.valueOf(stopWatch.getTime()) + " msec for getAbundanceColumnDefinitionsForProteinByExperiment"));
        }
    }

    @Override
    public TypedTableResultSet<ProteinInfo> listProteinsByExperiment(ListProteinByExperimentCriteria criteria) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            String sessionToken = this.getSessionToken();
            TechId experimentID = criteria.getExperimentID();
            double fdr = criteria.getFalseDiscoveryRate();
            AggregateFunction aggregateFunction = criteria.getAggregateFunction();
            String treatmentTypeCode = criteria.getTreatmentTypeCode();
            boolean aggregateOnOriginal = criteria.isAggregateOriginal();
            TypedTableResultSet<ProteinInfo> typedTableResultSet = this.listEntities(new ProteinProvider(this.server, sessionToken, experimentID, fdr, aggregateFunction, treatmentTypeCode, aggregateOnOriginal), criteria);
            return typedTableResultSet;
        }
        finally {
            operationLog.info((Object)(String.valueOf(stopWatch.getTime()) + " msec for listProteinsByExperiment"));
        }
    }

    @Override
    public String prepareExportProteins(TableExportCriteria<TableModelRowWithObject<ProteinInfo>> exportCriteria) {
        return this.prepareExportEntities(exportCriteria);
    }

    @Override
    public TypedTableResultSet<ProteinSummary> listProteinSummariesByExperiment(ListProteinSummaryByExperimentCriteria criteria) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            String sessionToken = this.getSessionToken();
            TypedTableResultSet<ProteinSummary> typedTableResultSet = this.listEntities(new ProteinSummaryProvider(this.server, sessionToken, criteria.getExperimentID()), criteria);
            return typedTableResultSet;
        }
        finally {
            operationLog.info((Object)(String.valueOf(stopWatch.getTime()) + " msec for listProteinSummariesByExperiment"));
        }
    }

    @Override
    public String prepareExportProteinSummary(TableExportCriteria<TableModelRowWithObject<ProteinSummary>> exportCriteria) {
        return this.prepareExportEntities(exportCriteria);
    }

    @Override
    public ProteinByExperiment getProteinByExperiment(TechId experimentID, TechId proteinReferenceID) {
        String sessionToken = this.getSessionToken();
        return this.server.getProteinByExperiment(sessionToken, experimentID, proteinReferenceID);
    }

    @Override
    public TypedTableResultSet<ProteinSequence> listSequencesByProteinReference(ListProteinSequenceCriteria criteria) {
        String sessionToken = this.getSessionToken();
        return this.listEntities(new ProteinSequenceProvider(this.server, sessionToken, criteria.getExperimentID(), criteria.getProteinReferenceID()), criteria);
    }

    @Override
    public String prepareExportProteinSequences(TableExportCriteria<TableModelRowWithObject<ProteinSequence>> exportCriteria) {
        return this.prepareExportEntities(exportCriteria);
    }

    @Override
    public TypedTableResultSet<DataSetProtein> listProteinsByExperimentAndReference(ListProteinByExperimentAndReferenceCriteria criteria) {
        String sessionToken = this.getSessionToken();
        return this.listEntities(new DataSetProteinProvider(this.server, sessionToken, criteria.getExperimentID(), criteria.getProteinReferenceID()), criteria);
    }

    @Override
    public String prepareExportDataSetProteins(TableExportCriteria<TableModelRowWithObject<DataSetProtein>> exportCriteria) {
        return this.prepareExportEntities(exportCriteria);
    }

    @Override
    public TypedTableResultSet<ProteinRelatedSample> listProteinRelatedSamplesByProtein(ListSampleAbundanceByProteinCriteria criteria) {
        String sessionToken = this.getSessionToken();
        ProteinRelatedSampleProvider provider = new ProteinRelatedSampleProvider(this.server, sessionToken, criteria.getExperimentID(), criteria.getProteinReferenceID());
        return this.listEntities(provider, criteria);
    }

    @Override
    public String prepareExportProteinRelatedSamples(TableExportCriteria<TableModelRowWithObject<ProteinRelatedSample>> exportCriteria) throws UserFailureException {
        return this.prepareExportEntities(exportCriteria);
    }

    @Override
    public TypedTableResultSet<Sample> listRawDataSamples(IResultSetConfig<String, TableModelRowWithObject<Sample>> criteria) throws UserFailureException {
        String sessionToken = this.getSessionToken();
        RawDataSampleProvider rawDataSampleProvider = new RawDataSampleProvider(this.proteomicsDataService, sessionToken);
        DataProviderAdapter<Sample> dataProvider = new DataProviderAdapter<Sample>(rawDataSampleProvider);
        ResultSet<Sample> resultSet = this.listEntities(criteria, dataProvider);
        return new TypedTableResultSet<Sample>(resultSet);
    }

    @Override
    public String prepareExportRawDataSamples(TableExportCriteria<TableModelRowWithObject<Sample>> exportCriteria) {
        return this.prepareExportEntities(exportCriteria);
    }

    @Override
    public void processRawData(String dataSetProcessingKey, long[] rawDataSampleIDs, String dataSetType) {
        this.proteomicsDataService.processRawData(this.getSessionToken(), dataSetProcessingKey, rawDataSampleIDs, dataSetType);
    }
}

