/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.proteomics.server.api.v1;

import ch.systemsx.cisd.authentication.ISessionManager;
import ch.systemsx.cisd.openbis.common.spring.IInvocationLoggerContext;
import ch.systemsx.cisd.openbis.generic.shared.AbstractServerLogger;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.api.v1.IProteomicsDataService;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.api.v1.dto.DataSet;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.api.v1.dto.DataStoreServerProcessingPluginInfo;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.api.v1.dto.Experiment;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.api.v1.dto.MsInjectionDataInfo;
import java.util.List;

class ProteomicsDataServiceLogger
extends AbstractServerLogger
implements IProteomicsDataService {
    ProteomicsDataServiceLogger(ISessionManager<Session> sessionManager, IInvocationLoggerContext context) {
        super(sessionManager, context);
    }

    @Override
    public String tryToAuthenticateAtRawDataServer(String userID, String userPassword) {
        return null;
    }

    @Override
    public List<MsInjectionDataInfo> listRawDataSamples(String sessionToken, String userID) {
        this.logAccess(sessionToken, "list_raw_data_samples", "USER_ID(%s)", userID);
        return null;
    }

    @Override
    public List<DataStoreServerProcessingPluginInfo> listDataStoreServerProcessingPluginInfos(String sessionToken) {
        this.logAccess(sessionToken, "list_data_store_services", "", new Object[0]);
        return null;
    }

    @Override
    public void processingRawData(String sessionToken, String userID, String dataSetProcessingKey, long[] rawDataSampleIDs, String dataSetType) {
        int numberOfDataSets = rawDataSampleIDs == null ? 0 : rawDataSampleIDs.length;
        this.logAccess(sessionToken, "copy_raw_data", "USER_ID(%s) DSS_PROCESSING_PLUGIN(%s) NUMBER_OF_DATA_SETS(%s) DATA_SET_TYPE(%s)", userID, dataSetProcessingKey, numberOfDataSets, dataSetType);
    }

    @Override
    public void processDataSets(String sessionToken, String userID, String dataSetProcessingKey, List<String> dataSetCodes) {
        this.logAccess(sessionToken, "process_data_sets", "USER_ID(%s) DSS_PROCESSING_PLUGIN(%s) DATA_SETS(%s)", userID, dataSetProcessingKey, dataSetCodes);
    }

    @Override
    public List<Experiment> listSearchExperiments(String sessionToken, String userID) {
        this.logAccess(sessionToken, "list_search_experiments");
        return null;
    }

    @Override
    public List<Experiment> listExperiments(String sessionToken, String userID, String experimentTypeCode) {
        this.logAccess(sessionToken, "list_search_experiments", "EXPERIMENT_TYPE(%s)", experimentTypeCode);
        return null;
    }

    @Override
    public List<DataSet> listDataSetsByExperiment(String sessionToken, String userID, long experimentID) {
        this.logAccess(sessionToken, "list_data_sets_by_experiment", "EXPERIMENT_ID(%s)", experimentID);
        return null;
    }

    @Override
    public void processSearchData(String sessionToken, String userID, String dataSetProcessingKey, long[] searchExperimentIDs) {
        int numberOfDataSets = searchExperimentIDs == null ? 0 : searchExperimentIDs.length;
        this.logAccess(sessionToken, "copy_search_data", "NUMBER_OF_DATA_SETS(%s)", numberOfDataSets);
    }

    @Override
    public void processProteinResultDataSets(String sessionToken, String userID, String dataSetProcessingKey, String experimentTypeCode, long[] experimentIDs) {
        int experimentCount = experimentIDs == null ? 0 : experimentIDs.length;
        this.logAccess(sessionToken, "process_protein_result_data_sets", "DSS_PROCESSING_PLUGIN(%s) EXPERIMENT_TYPE(%s) NUMBER_OF_EXPERIMENTS(%s)", dataSetProcessingKey, experimentTypeCode, experimentCount);
    }

    @Override
    public int getMajorVersion() {
        return 1;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }
}

