/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.proteomics.server.business;

import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.plugin.proteomics.server.business.ISampleProvider;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.dto.ProteinAbundance;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.dto.ProteinReferenceWithProtein;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.dto.ProteinWithAbundances;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

class AbundanceManager {
    private final List<ProteinWithAbundances> proteins = new ArrayList<ProteinWithAbundances>();
    private final ISampleProvider sampleProvider;
    private final Set<Long> sampleIDs = new TreeSet<Long>();

    AbundanceManager(ISampleProvider sampleProvider) {
        this.sampleProvider = sampleProvider;
    }

    public void handle(ProteinReferenceWithProtein proteinReference, List<ProteinAbundance> listOrNull) {
        String accessionNumber = proteinReference.getAccessionNumber();
        ProteinWithAbundances protein = new ProteinWithAbundances();
        protein.setCoverage(proteinReference.getCoverage());
        protein.setId(proteinReference.getId());
        protein.setDescription(proteinReference.getDescription());
        protein.setAccessionNumber(accessionNumber);
        this.proteins.add(protein);
        if (listOrNull != null) {
            for (ProteinAbundance proteinAbundance : listOrNull) {
                String samplePermID = proteinAbundance.getSamplePermID();
                Long sampleID = this.getSampleIDOrParentSampleID(samplePermID);
                this.sampleIDs.add(sampleID);
                protein.addAbundanceFor(sampleID, proteinAbundance.getAbundance());
            }
        }
    }

    private Long getSampleIDOrParentSampleID(String samplePermID) {
        Sample sample = this.sampleProvider.getSample(samplePermID);
        Sample parent = sample.getGeneratedFrom();
        return parent == null ? sample.getId() : parent.getId();
    }

    public Collection<ProteinWithAbundances> getProteinsWithAbundances() {
        return this.proteins;
    }

    public final Collection<Long> getSampleIDs() {
        return this.sampleIDs;
    }
}

