/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.proteomics.server.business;

public class AccessionNumberBuilder {
    static final String DECOY_PREFIX = "DECOY_";
    private static final char SEPARATOR = '|';
    private final String typeOrNull;
    private final String accessionNumber;

    public AccessionNumberBuilder(String fullAccessionNumber) {
        int indexOfFirstSeparator = fullAccessionNumber.indexOf(124);
        if (indexOfFirstSeparator < 0) {
            this.typeOrNull = null;
            this.accessionNumber = fullAccessionNumber;
        } else {
            String firstItem = fullAccessionNumber.substring(0, indexOfFirstSeparator);
            int decoyPrefixIndex = firstItem.startsWith(DECOY_PREFIX) ? DECOY_PREFIX.length() : 0;
            String prefix = firstItem.substring(0, decoyPrefixIndex);
            this.typeOrNull = firstItem.substring(decoyPrefixIndex);
            int startIndex = indexOfFirstSeparator + 1;
            int indexOfSecondSeparator = fullAccessionNumber.indexOf(124, startIndex);
            this.accessionNumber = indexOfSecondSeparator < 0 ? this.addPrefixIfNecessary(prefix, fullAccessionNumber.substring(startIndex)) : this.addPrefixIfNecessary(prefix, fullAccessionNumber.substring(startIndex, indexOfSecondSeparator));
        }
    }

    private String addPrefixIfNecessary(String prefix, String string) {
        return string.startsWith(prefix) ? string : String.valueOf(prefix) + string;
    }

    public final String getTypeOrNull() {
        return this.typeOrNull;
    }

    public final String getAccessionNumber() {
        return this.accessionNumber;
    }
}

