/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.proteomics.server.business;

import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.plugin.proteomics.server.business.AbstractBusinessObject;
import ch.systemsx.cisd.openbis.plugin.proteomics.server.business.IProteinSequenceTable;
import ch.systemsx.cisd.openbis.plugin.proteomics.server.dataaccess.IPhosphoNetXDAOFactory;
import ch.systemsx.cisd.openbis.plugin.proteomics.server.dataaccess.IProteinQueryDAO;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.basic.dto.ProteinSequence;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.dto.Sequence;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.lemnik.eodsql.DataSet;

class ProteinSequenceTable
extends AbstractBusinessObject
implements IProteinSequenceTable {
    private List<ProteinSequence> proteinSequences;
    private Map<Long, String> databaseIDToShortNameMap;

    ProteinSequenceTable(IDAOFactory daoFactory, IPhosphoNetXDAOFactory specificDAOFactory, Session session) {
        super(daoFactory, specificDAOFactory, session);
    }

    @Override
    public List<ProteinSequence> getSequences() {
        if (this.proteinSequences == null) {
            throw new IllegalStateException("Sequences not loaded.");
        }
        return this.proteinSequences;
    }

    @Override
    public String getShortName(long databaseID) {
        if (this.databaseIDToShortNameMap == null) {
            throw new IllegalStateException("Sequences not loaded.");
        }
        String shortName = this.databaseIDToShortNameMap.get(databaseID);
        if (shortName == null) {
            throw new IllegalArgumentException("No sequence found for databaseID " + databaseID);
        }
        return shortName;
    }

    @Override
    public void loadByReference(TechId experimentID, TechId proteinReferenceID) {
        IProteinQueryDAO proteinQueryDAO = this.getSpecificDAOFactory().getProteinQueryDAO(experimentID);
        DataSet<Sequence> sequences = proteinQueryDAO.listProteinSequencesByProteinReference(proteinReferenceID.getId());
        this.proteinSequences = new ArrayList<ProteinSequence>(sequences.size());
        this.databaseIDToShortNameMap = new HashMap<Long, String>();
        int number = 0;
        for (Sequence sequence : sequences) {
            ProteinSequence proteinSequence = new ProteinSequence();
            proteinSequence.setId(new TechId(sequence.getId()));
            String shortName = this.createShortName(number++);
            proteinSequence.setShortName(shortName);
            proteinSequence.setSequence(sequence.getSequence());
            long databaseID = sequence.getDatabaseID();
            proteinSequence.setDatabaseID(new TechId(databaseID));
            proteinSequence.setDatabaseNameAndVersion(sequence.getDatabaseNameAndVersion());
            this.proteinSequences.add(proteinSequence);
            this.databaseIDToShortNameMap.put(databaseID, shortName);
        }
        sequences.close();
    }

    private String createShortName(int number) {
        StringBuilder builder = new StringBuilder();
        int n = number;
        while (n > 0 || builder.length() == 0) {
            builder.insert(0, "ABCEDEFGHIJKLMNOPQRSTUVWXYZ".charAt(n % 26));
            n /= 26;
        }
        return builder.toString();
    }
}

