/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.proteomics.server.business;

import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IExperimentDAO;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.plugin.proteomics.server.business.AbstractBusinessObject;
import ch.systemsx.cisd.openbis.plugin.proteomics.server.business.ErrorModel;
import ch.systemsx.cisd.openbis.plugin.proteomics.server.business.IProteinSummaryTable;
import ch.systemsx.cisd.openbis.plugin.proteomics.server.dataaccess.IPhosphoNetXDAOFactory;
import ch.systemsx.cisd.openbis.plugin.proteomics.server.dataaccess.IProteinQueryDAO;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.basic.dto.ProteinSummary;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.dto.ProteinReferenceWithProbabilityAndPeptide;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.lemnik.eodsql.DataSet;

class ProteinSummaryTable
extends AbstractBusinessObject
implements IProteinSummaryTable {
    static final double[] FDR_LEVELS = new double[]{0.0, 0.01, 0.025, 0.05, 0.1};
    private List<ProteinSummary> summaries;

    ProteinSummaryTable(IDAOFactory daoFactory, IPhosphoNetXDAOFactory specificDAOFactory, Session session) {
        super(daoFactory, specificDAOFactory, session);
    }

    @Override
    public List<ProteinSummary> getProteinSummaries() {
        return this.summaries;
    }

    @Override
    public void load(TechId experimentID) {
        IExperimentDAO experimentDAO = this.getDaoFactory().getExperimentDAO();
        String permID = ((ExperimentPE)experimentDAO.getByTechId(experimentID)).getPermId();
        IProteinQueryDAO dao = this.getSpecificDAOFactory().getProteinQueryDAO(experimentID);
        ErrorModel errorModel = new ErrorModel(dao);
        DataSet<ProteinReferenceWithProbabilityAndPeptide> resultSet = dao.listProteinsWithProbabilityAndPeptidesByExperiment(permID);
        ArrayList<Counter> counters = new ArrayList<Counter>(FDR_LEVELS.length);
        double[] dArray = FDR_LEVELS;
        int n = FDR_LEVELS.length;
        int n2 = 0;
        while (n2 < n) {
            double fdrLevel = dArray[n2];
            counters.add(new Counter(fdrLevel));
            ++n2;
        }
        try {
            for (ProteinReferenceWithProbabilityAndPeptide protein : resultSet) {
                long dataSetID = protein.getDataSetID();
                double probability = protein.getProbability();
                double fdr = errorModel.calculateFalsDiscoveryRate(dataSetID, probability);
                for (Counter counter : counters) {
                    counter.handle(fdr, protein);
                }
            }
            this.summaries = this.getSummaries(counters);
        }
        finally {
            resultSet.close();
        }
    }

    private List<ProteinSummary> getSummaries(List<Counter> counters) {
        ArrayList<ProteinSummary> list = new ArrayList<ProteinSummary>(counters.size());
        for (Counter counter : counters) {
            list.add(counter.getProteinSummary());
        }
        return list;
    }

    private static final class Counter {
        private final double fdrLevel;
        private final Set<Long> proteins;
        private final Set<Long> decoyProteins;
        private final Set<String> peptides;
        private final Set<String> decoyPeptides;

        Counter(double fdrLevel) {
            this.fdrLevel = fdrLevel;
            this.proteins = new HashSet<Long>();
            this.decoyProteins = new HashSet<Long>();
            this.peptides = new HashSet<String>();
            this.decoyPeptides = new HashSet<String>();
        }

        public ProteinSummary getProteinSummary() {
            ProteinSummary proteinSummary = new ProteinSummary();
            proteinSummary.setFDR(this.fdrLevel);
            proteinSummary.setProteinCount(this.proteins.size());
            proteinSummary.setPeptideCount(this.peptides.size());
            proteinSummary.setDecoyProteinCount(this.decoyProteins.size());
            proteinSummary.setDecoyPeptideCount(this.decoyPeptides.size());
            return proteinSummary;
        }

        public void handle(double fdr, ProteinReferenceWithProbabilityAndPeptide protein) {
            if (Double.isNaN(fdr) || fdr <= this.fdrLevel) {
                String accessionNumber = protein.getAccessionNumber();
                if (accessionNumber.startsWith("DECOY_")) {
                    this.decoyProteins.add(protein.getId());
                    this.decoyPeptides.add(protein.getPeptideSequence());
                } else {
                    this.proteins.add(protein.getId());
                    this.peptides.add(protein.getPeptideSequence());
                }
            }
        }
    }
}

