/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.proteomics.shared.dto;

import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MsInjectionSample {
    private final Sample sample;
    private final Map<String, AbstractExternalData> latestDataSets = new LinkedHashMap<String, AbstractExternalData>();
    private final List<AbstractExternalData> dataSets;

    public MsInjectionSample(Sample sample, List<AbstractExternalData> dataSets) {
        this.sample = sample;
        this.dataSets = dataSets;
        this.add(dataSets);
    }

    private void add(Collection<AbstractExternalData> datasets) {
        if (datasets != null) {
            for (AbstractExternalData dataSet : datasets) {
                this.addLatestDataSet(dataSet);
                this.add(dataSet.getChildren());
            }
        }
    }

    public Sample getSample() {
        return this.sample;
    }

    public final List<AbstractExternalData> getDataSets() {
        return this.dataSets;
    }

    public Map<String, AbstractExternalData> getLatestDataSets() {
        return this.latestDataSets;
    }

    private void addLatestDataSet(AbstractExternalData dataSet) {
        String dataSetTypeCode = dataSet.getDataSetType().getCode();
        Date registrationDate = dataSet.getRegistrationDate();
        AbstractExternalData latestDataSet = this.latestDataSets.get(dataSetTypeCode);
        if (latestDataSet == null || latestDataSet.getRegistrationDate().getTime() < registrationDate.getTime()) {
            this.latestDataSets.put(dataSetTypeCode, dataSet);
        }
    }

    public String toString() {
        return String.valueOf(this.sample.getIdentifier()) + ":" + this.latestDataSets;
    }
}

