/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.api.v1;

import ch.systemsx.cisd.openbis.dss.screening.shared.api.v1.LoadImageConfiguration;
import ch.systemsx.cisd.openbis.plugin.screening.client.api.v1.IPlateImageHandler;
import ch.systemsx.cisd.openbis.plugin.screening.client.api.v1.IScreeningOpenbisServiceFacade;
import ch.systemsx.cisd.openbis.plugin.screening.client.api.v1.ScreeningOpenbisServiceFacadeFactory;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.ImageDatasetMetadata;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.ImageDatasetReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.ImageSize;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.Plate;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.PlateImageReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.WellPosition;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.PropertyConfigurator;
import org.springframework.util.StopWatch;

public class LoadEmptyImagesTest {
    private final IScreeningOpenbisServiceFacade facade;

    public static void main(String[] args) throws IOException {
        if (args.length != 3) {
            System.err.println("Usage: <user> <password> <openbis-server-url>");
            System.err.println("Example parameters: test-user my-password http://localhost:8888");
            System.exit(1);
            return;
        }
        LoadEmptyImagesTest.configureLogging();
        String userId = args[0];
        String userPassword = args[1];
        String serverUrl = args[2];
        LoadEmptyImagesTest.print(String.format("Connecting to the server '%s' as a user '%s.", serverUrl, userId));
        IScreeningOpenbisServiceFacade facade = ScreeningOpenbisServiceFacadeFactory.tryCreate(userId, userPassword, serverUrl);
        if (facade == null) {
            System.err.println("Authentication failed: check the user name and password.");
            System.exit(1);
            return;
        }
        LoadEmptyImagesTest newMe = new LoadEmptyImagesTest(facade);
        newMe.runTest();
        newMe.logout();
    }

    private LoadEmptyImagesTest(IScreeningOpenbisServiceFacade facade) {
        this.facade = facade;
    }

    public void runTest() throws IOException {
        List<PlateImageReference> imageReferences = this.findPlateImagesToLoad(1000);
        try {
            this.runAndTime(imageReferences, 1);
            throw new RuntimeException("Expected exception not thrown");
        }
        catch (Exception exception) {
            try {
                this.runAndTime(imageReferences, 2);
                throw new RuntimeException("Expected exception not thrown");
            }
            catch (Exception exception2) {
                return;
            }
        }
    }

    private void runAndTime(List<PlateImageReference> imageReferences, int whichMethod) throws IOException {
        LoadEmptyImagesTest.print("Retrieving images...");
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        LoadImageConfiguration config = new LoadImageConfiguration();
        config.setDesiredImageSize(new ImageSize(256, 256));
        switch (whichMethod) {
            case 0: {
                this.loadThumbnailImageWellCaching(imageReferences);
                break;
            }
            case 1: {
                config.setDesiredImageSize(null);
                this.loadImageWellCaching(imageReferences, config);
            }
            case 2: {
                config.setDesiredImageSize(null);
                this.loadImages(imageReferences, config);
                break;
            }
        }
        stopWatch.stop();
        long timeInMs = stopWatch.getLastTaskTimeMillis();
        double timeInSec = (double)timeInMs / 1000.0;
        LoadEmptyImagesTest.print("Retrieving " + imageReferences.size() + " images took " + timeInMs + " ms = " + timeInSec + " sec");
        LoadEmptyImagesTest.print("Test done.");
    }

    private void loadImageWellCaching(List<PlateImageReference> imageReferences, LoadImageConfiguration config) throws IOException {
        for (PlateImageReference imageReference : imageReferences) {
            this.facade.loadImageWellCaching(imageReference, config.getDesiredImageSize());
        }
    }

    private void loadThumbnailImageWellCaching(List<PlateImageReference> imageReferences) throws IOException {
        for (PlateImageReference imageReference : imageReferences) {
            this.facade.loadThumbnailImageWellCaching(imageReference);
        }
    }

    private void loadImages(List<PlateImageReference> imageReferences, LoadImageConfiguration config) throws IOException {
        this.facade.loadImages(imageReferences, config, new IPlateImageHandler(){

            @Override
            public void handlePlateImage(PlateImageReference plateImageReference, byte[] imageFileBytes) {
                System.out.println("Image size: " + imageFileBytes.length);
            }
        });
    }

    private List<PlateImageReference> findPlateImagesToLoad(int numberOfImagesDesired) {
        LoadEmptyImagesTest.print("Looking for images to load...");
        ArrayList<PlateImageReference> plateImages = new ArrayList<PlateImageReference>();
        List<Plate> plates = this.facade.listPlates();
        ArrayList<Plate> platesOfInterest = new ArrayList<Plate>();
        for (Plate plate : plates) {
            if (!plate.getAugmentedCode().equals("/DEMO/ALL")) continue;
            platesOfInterest.add(plate);
        }
        List<ImageDatasetReference> imageDatasets = this.facade.listRawImageDatasets(platesOfInterest);
        if (imageDatasets.size() == 0) {
            return plateImages;
        }
        for (ImageDatasetReference imageDataset : imageDatasets) {
            this.addAllPlateImagesWithNoImagesFromDataset(plateImages, imageDataset, numberOfImagesDesired);
        }
        LoadEmptyImagesTest.print("...found " + plateImages.size() + " images.");
        return plateImages;
    }

    private void addAllPlateImagesWithNoImagesFromDataset(ArrayList<PlateImageReference> plateImages, ImageDatasetReference imageDataset, int numberOfImagesDesired) {
        ImageDatasetMetadata metadata = this.facade.listImageMetadata(imageDataset);
        int numberOfRows = metadata.getTilesRows();
        int numberOfCols = metadata.getTilesCols();
        List<String> channels = Arrays.asList("Merged Channels");
        int numberOfTileRows = metadata.getTilesRows();
        int numberOfTileCols = metadata.getTilesCols();
        int row = 1;
        while (row <= numberOfRows) {
            int col = 1;
            while (col <= numberOfCols) {
                WellPosition well = new WellPosition(row, col);
                for (String channel : channels) {
                    int tileRow = 0;
                    while (tileRow < numberOfTileRows) {
                        int tileCol = 0;
                        while (tileCol < numberOfTileCols) {
                            int tile = tileRow * numberOfTileCols + tileCol;
                            PlateImageReference imageRef = new PlateImageReference(tile, channel, well, imageDataset);
                            plateImages.add(imageRef);
                            ++tileCol;
                        }
                        ++tileRow;
                    }
                }
                ++col;
            }
            ++row;
        }
    }

    public void logout() {
        this.facade.logout();
    }

    private static void print(String msg) {
        System.out.println(new Date() + "\t" + msg);
    }

    private static void configureLogging() {
        Properties props = new Properties();
        props.put("log4j.appender.STDOUT", "org.apache.log4j.ConsoleAppender");
        props.put("log4j.appender.STDOUT.layout", "org.apache.log4j.PatternLayout");
        props.put("log4j.appender.STDOUT.layout.ConversionPattern", "%d %-5p [%t] %c - %m%n");
        props.put("log4j.rootLogger", "INFO, STDOUT");
        PropertyConfigurator.configure((Properties)props);
    }
}

