/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.TabContent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DatabaseModificationAwareComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.IDatabaseModificationObserver;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Material;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.material.GenericMaterialViewer;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.IScreeningClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.MaterialMergedSummarySection;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.WellSearchMaterialSection;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellSearchCriteria;
import com.extjs.gxt.ui.client.widget.Component;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.ArrayList;
import java.util.List;

public class ImagingMaterialViewer
extends GenericMaterialViewer {
    private final IViewContext<IScreeningClientServiceAsync> screeningViewContext;
    private final WellSearchCriteria.ExperimentSearchCriteria initialExperimentCriteriaOrNull;
    private final WellSearchCriteria.AnalysisProcedureCriteria analysisProcedureCriteria;

    public static DatabaseModificationAwareComponent create(IViewContext<IScreeningClientServiceAsync> viewContext, TechId materialId, WellSearchCriteria.ExperimentSearchCriteria experimentCriteriaOrNull, WellSearchCriteria.AnalysisProcedureCriteria analysisProcedureCriteria) {
        ImagingMaterialViewer viewer = new ImagingMaterialViewer(viewContext, materialId, experimentCriteriaOrNull, analysisProcedureCriteria);
        viewer.reloadAllData();
        return new DatabaseModificationAwareComponent((Component)viewer, (IDatabaseModificationObserver)viewer);
    }

    private ImagingMaterialViewer(IViewContext<IScreeningClientServiceAsync> viewContext, TechId materialTechId, WellSearchCriteria.ExperimentSearchCriteria experimentCriteriaOrNull, WellSearchCriteria.AnalysisProcedureCriteria analysisProcedureCriteria) {
        super(viewContext, materialTechId);
        this.screeningViewContext = viewContext;
        this.initialExperimentCriteriaOrNull = experimentCriteriaOrNull;
        this.analysisProcedureCriteria = analysisProcedureCriteria;
    }

    @Override
    protected void loadMaterialInfo(TechId materialTechId, AsyncCallback<Material> callback) {
        this.screeningViewContext.getCommonService().getMaterialInfo(materialTechId, callback);
    }

    @Override
    protected List<TabContent> createAdditionalSectionPanels(Material material) {
        ArrayList<TabContent> sections = new ArrayList<TabContent>();
        boolean restrictGlobalScopeLinkToProject = ImagingMaterialViewer.isRestrictGlobalScopeLinkToProject(this.initialExperimentCriteriaOrNull);
        WellSearchMaterialSection wellSearchSection = new WellSearchMaterialSection(this.screeningViewContext, this.materialId, this.initialExperimentCriteriaOrNull, this.analysisProcedureCriteria, restrictGlobalScopeLinkToProject);
        sections.add(wellSearchSection);
        MaterialMergedSummarySection summarySection = new MaterialMergedSummarySection(this.screeningViewContext, material, this.initialExperimentCriteriaOrNull, this.analysisProcedureCriteria, restrictGlobalScopeLinkToProject);
        sections.add(summarySection);
        return sections;
    }

    private static boolean isRestrictGlobalScopeLinkToProject(WellSearchCriteria.ExperimentSearchCriteria experimentCriteriaOrNull) {
        if (experimentCriteriaOrNull == null) {
            return false;
        }
        return experimentCriteriaOrNull.getRestrictGlobalSearchLinkToProject();
    }
}

