/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.AbstractTabItemFactory;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DefaultTabItem;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DispatcherHelper;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.ITabItem;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.help.HelpPageIdentifier;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IDisposableComponent;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Material;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.IScreeningClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.MaterialFeaturesFromAllExperimentsComponent;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.utils.MaterialComponentUtils;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.ui.columns.specific.ScreeningLinkExtractor;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellSearchCriteria;
import com.google.gwt.user.client.rpc.AsyncCallback;

public class MaterialFeaturesFromAllExperimentsViewer {
    private final IViewContext<IScreeningClientServiceAsync> screeningViewContext;
    private final WellSearchCriteria.AnalysisProcedureCriteria analysisProcedureCriteria;
    private final boolean computeRanks;

    public static void openTab(IViewContext<IScreeningClientServiceAsync> screeningViewContext, MaterialIdentifier materialIdentifier, final WellSearchCriteria.ExperimentSearchByProjectCriteria experimentCriteria, WellSearchCriteria.AnalysisProcedureCriteria analysisProcedureCriteria, boolean computeRanks) {
        final MaterialFeaturesFromAllExperimentsViewer viewer = new MaterialFeaturesFromAllExperimentsViewer(screeningViewContext, analysisProcedureCriteria, computeRanks);
        screeningViewContext.getCommonService().getMaterialInfo(materialIdentifier, (AsyncCallback<Material>)new AbstractAsyncCallback<Material>(screeningViewContext){

            @Override
            protected void process(Material result) {
                viewer.openTab(result, experimentCriteria);
            }
        });
    }

    private MaterialFeaturesFromAllExperimentsViewer(IViewContext<IScreeningClientServiceAsync> screeningViewContext, WellSearchCriteria.AnalysisProcedureCriteria analysisProcedureCriteria, boolean computeRanks) {
        this.screeningViewContext = screeningViewContext;
        this.analysisProcedureCriteria = analysisProcedureCriteria;
        this.computeRanks = computeRanks;
    }

    private void openTab(Material material, WellSearchCriteria.ExperimentSearchByProjectCriteria experimentCriteria) {
        AbstractTabItemFactory factory = this.createTabFactory(material, experimentCriteria);
        DispatcherHelper.dispatchNaviEvent(factory);
    }

    private AbstractTabItemFactory createTabFactory(final Material material, final WellSearchCriteria.ExperimentSearchByProjectCriteria experimentCriteria) {
        return new AbstractTabItemFactory(){

            @Override
            public String getId() {
                return "openbis_-screening-MATERIAL_FEATURES_FROM_ALL_EXPERIMENTS" + material.getPermId();
            }

            @Override
            public ITabItem create() {
                IDisposableComponent tabComponent = MaterialFeaturesFromAllExperimentsComponent.createComponent(MaterialFeaturesFromAllExperimentsViewer.this.screeningViewContext, material, experimentCriteria, MaterialFeaturesFromAllExperimentsViewer.this.analysisProcedureCriteria, MaterialFeaturesFromAllExperimentsViewer.this.computeRanks);
                return DefaultTabItem.create(this.getTabTitle(), tabComponent, MaterialFeaturesFromAllExperimentsViewer.this.screeningViewContext);
            }

            @Override
            public String tryGetLink() {
                return ScreeningLinkExtractor.createMaterialDetailsLink((IEntityInformationHolder)material, experimentCriteria.asExtendedCriteria());
            }

            @Override
            public String getTabTitle() {
                return String.valueOf(MaterialComponentUtils.getMaterialName(material)) + " features in all experiments";
            }

            @Override
            public HelpPageIdentifier getHelpPageIdentifier() {
                return HelpPageIdentifier.createSpecific("Material features in all experiments");
            }
        };
    }
}

