/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers;

import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.MovieButtonsFrameLoader;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.MovieDelay;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Widget;

public class MovieButtons
extends Composite {
    private int currentFrame = 0;
    private int numberOfFrames;
    private MovieButtonsFrameLoader frameLoader;
    private MovieButtonsView view;
    private MovieButtonsState state;

    public MovieButtons(int numberOfFrames) {
        this.numberOfFrames = numberOfFrames;
        this.frameLoader = MovieButtonsFrameLoader.NULL_LOADER;
        this.initView();
        this.initState();
    }

    private void initView() {
        this.view = new MovieButtonsView();
        this.view.addPlayListener(new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent event) {
                MovieButtons.this.handlePlay();
            }
        });
        this.view.addStopListener(new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent event) {
                MovieButtons.this.handleStop();
            }
        });
        this.view.addPreviousListener(new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent event) {
                MovieButtons.this.handlePrevious();
            }
        });
        this.view.addNextListener(new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent event) {
                MovieButtons.this.handleNext();
            }
        });
        this.initWidget((Widget)this.view);
    }

    private void initState() {
        this.setState(new MovieButtonsStoppedState());
    }

    private MovieButtonsState getState() {
        return this.state;
    }

    private void setState(MovieButtonsState newState) {
        this.state = newState;
        this.state.init();
    }

    public MovieButtonsFrameLoader getFrameLoader() {
        return this.frameLoader;
    }

    public void setFrameLoader(MovieButtonsFrameLoader frameLoader) {
        if (frameLoader == null) {
            throw new IllegalArgumentException("Frame loader was null");
        }
        this.frameLoader = frameLoader;
    }

    public int getFrame() {
        return this.state.handleGetFrame();
    }

    public void setFrame(int frame) {
        this.state.handleSetFrame(frame);
    }

    public int getDelay() {
        return this.view.getDelay();
    }

    public void setDelay(int delay) {
        this.view.setDelay(delay);
    }

    public void addDelayChangeHandler(ChangeHandler handler) {
        this.view.addDelayChangeHandler(handler);
    }

    private boolean isFirstFrame() {
        return this.getFrame() == 0;
    }

    private boolean isLastFrame() {
        return this.getFrame() == this.numberOfFrames - 1;
    }

    private void loadFrame(int frame, AsyncCallback<Void> callback) {
        this.frameLoader.loadFrame(frame, callback);
    }

    private void loadFrame(int frame) {
        this.loadFrame(frame, new AsyncCallback<Void>(){

            public void onSuccess(Void result) {
            }

            public void onFailure(Throwable caught) {
            }
        });
    }

    private void handlePlay() {
        this.state.handlePlay();
    }

    private void handleStop() {
        this.state.handleStop();
    }

    private void handlePrevious() {
        this.state.handlePrevious();
    }

    private void handleNext() {
        this.state.handleNext();
    }

    protected void onUnload() {
        this.handleStop();
    }

    private class MovieButtonsPlayingState
    implements MovieButtonsState {
        private MovieButtonsPlayingState() {
        }

        @Override
        public void init() {
            MovieButtons.this.view.setPlayEnabled(false);
            MovieButtons.this.view.setStopEnabled(true);
            MovieButtons.this.view.setPreviousEnabled(true);
            MovieButtons.this.view.setNextEnabled(true);
            this.loadNextFrame(1);
        }

        @Override
        public void handlePlay() {
        }

        @Override
        public void handleStop() {
            MovieButtons.this.setState(new MovieButtonsStoppedState());
        }

        @Override
        public void handlePrevious() {
            this.handleStop();
        }

        @Override
        public void handleNext() {
            this.handleStop();
        }

        @Override
        public int handleGetFrame() {
            return MovieButtons.this.currentFrame;
        }

        @Override
        public void handleSetFrame(int frame) {
            MovieButtons.this.currentFrame = frame;
        }

        private void loadNextFrame(int delay) {
            Timer timer = new Timer(){

                public void run() {
                    final long startTime = System.currentTimeMillis();
                    if (MovieButtons.this.isLastFrame()) {
                        MovieButtonsPlayingState.this.handleStop();
                        MovieButtons.this.setFrame(0);
                    } else {
                        MovieButtons.this.setFrame(MovieButtons.this.getFrame() + 1);
                        MovieButtons.this.loadFrame(MovieButtons.this.getFrame(), (AsyncCallback<Void>)((AsyncCallback)new AsyncCallback<Void>(){

                            public void onSuccess(Void result) {
                                if (MovieButtonsPlayingState.this == MovieButtons.this.getState()) {
                                    int prefferedDelay = MovieButtons.this.view.getDelay();
                                    int currentDelay = (int)(System.currentTimeMillis() - startTime);
                                    if (currentDelay < prefferedDelay) {
                                        MovieButtonsPlayingState.this.loadNextFrame(prefferedDelay - currentDelay);
                                    } else {
                                        MovieButtonsPlayingState.this.loadNextFrame(1);
                                    }
                                }
                            }

                            public void onFailure(Throwable caught) {
                                this.onSuccess(null);
                            }
                        }));
                    }
                }
            };
            timer.schedule(delay);
        }
    }

    private static interface MovieButtonsState {
        public void init();

        public void handlePlay();

        public void handleStop();

        public void handlePrevious();

        public void handleNext();

        public int handleGetFrame();

        public void handleSetFrame(int var1);
    }

    private class MovieButtonsStoppedState
    implements MovieButtonsState {
        private MovieButtonsStoppedState() {
        }

        @Override
        public void init() {
            MovieButtons.this.view.setPlayEnabled(true);
            MovieButtons.this.view.setStopEnabled(false);
            MovieButtons.this.view.setPreviousEnabled(!MovieButtons.this.isFirstFrame());
            MovieButtons.this.view.setNextEnabled(!MovieButtons.this.isLastFrame());
        }

        @Override
        public void handlePlay() {
            if (MovieButtons.this.isLastFrame()) {
                MovieButtons.this.setFrame(0);
            }
            MovieButtons.this.setState(new MovieButtonsPlayingState());
        }

        @Override
        public void handleStop() {
        }

        @Override
        public void handlePrevious() {
            if (!MovieButtons.this.isFirstFrame()) {
                MovieButtons.this.setFrame(MovieButtons.this.getFrame() - 1);
            }
        }

        @Override
        public void handleNext() {
            if (!MovieButtons.this.isLastFrame()) {
                MovieButtons.this.setFrame(MovieButtons.this.getFrame() + 1);
            }
        }

        @Override
        public int handleGetFrame() {
            return MovieButtons.this.currentFrame;
        }

        @Override
        public void handleSetFrame(int frame) {
            MovieButtons.this.currentFrame = frame;
            MovieButtons.this.view.setPreviousEnabled(!MovieButtons.this.isFirstFrame());
            MovieButtons.this.view.setNextEnabled(!MovieButtons.this.isLastFrame());
            MovieButtons.this.loadFrame(frame);
        }
    }

    private class MovieButtonsView
    extends Composite {
        private Button playButton = new Button("Play");
        private Button stopButton = new Button("Stop");
        private Button previousButton = new Button("<<");
        private Button nextButton = new Button(">>");
        private MovieDelay delayInput = new MovieDelay();

        public MovieButtonsView() {
            HorizontalPanel panel = new HorizontalPanel();
            panel.setStyleName("movieButtons");
            panel.add((Widget)this.playButton);
            panel.add((Widget)this.stopButton);
            panel.add((Widget)this.previousButton);
            panel.add((Widget)this.nextButton);
            panel.add((Widget)this.delayInput);
            this.initWidget((Widget)panel);
        }

        public void addPlayListener(SelectionListener<ButtonEvent> listener) {
            this.playButton.addSelectionListener(listener);
        }

        public void addStopListener(SelectionListener<ButtonEvent> listener) {
            this.stopButton.addSelectionListener(listener);
        }

        public void addPreviousListener(SelectionListener<ButtonEvent> listener) {
            this.previousButton.addSelectionListener(listener);
        }

        public void addNextListener(SelectionListener<ButtonEvent> listener) {
            this.nextButton.addSelectionListener(listener);
        }

        public void setPlayEnabled(boolean enabled) {
            this.playButton.setEnabled(enabled);
        }

        public void setStopEnabled(boolean enabled) {
            this.stopButton.setEnabled(enabled);
        }

        public void setPreviousEnabled(boolean enabled) {
            this.previousButton.setEnabled(enabled);
        }

        public void setNextEnabled(boolean enabled) {
            this.nextButton.setEnabled(enabled);
        }

        public int getDelay() {
            return this.delayInput.getDelay();
        }

        public void setDelay(int delay) {
            this.delayInput.setDelay(delay);
        }

        public void addDelayChangeHandler(ChangeHandler handler) {
            this.delayInput.addDelayChangeHandler(handler);
        }
    }
}

