/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;

public class MovieDelay
extends Composite {
    private static final int DEFAULT_DELAY_VALUE_IN_MILLIS = 500;
    private static final int DEFAULT_DELAY_INPUT_LENGTH = 4;
    private Label nameLabel = new Label("delay:");
    private Label unitLabel = new Label("ms");
    private TextBox input = new TextBox();

    public MovieDelay() {
        this.input.setValue((Object)String.valueOf(500));
        this.input.setVisibleLength(4);
        this.input.setMaxLength(4);
        this.input.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                int delay = MovieDelay.this.parseDelay(MovieDelay.this.input.getValue());
                MovieDelay.this.input.setValue((Object)String.valueOf(delay), false);
            }
        });
        HorizontalPanel panel = new HorizontalPanel();
        panel.addStyleName("movieDelay");
        panel.add((Widget)this.nameLabel);
        panel.add((Widget)this.input);
        panel.add((Widget)this.unitLabel);
        this.initWidget((Widget)panel);
    }

    private int parseDelay(String delayString) {
        if (delayString == null || delayString.trim().length() == 0) {
            return 500;
        }
        try {
            int delay = Integer.parseInt(delayString);
            if (delay >= 1) {
                return delay;
            }
            return 500;
        }
        catch (NumberFormatException numberFormatException) {
            return 500;
        }
    }

    public int getDelay() {
        return this.parseDelay(this.input.getValue());
    }

    public void setDelay(int delay) {
        this.input.setValue((Object)String.valueOf(delay));
    }

    public void addDelayChangeHandler(ChangeHandler handler) {
        this.input.addChangeHandler(handler);
    }
}

