/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.logicalimage;

import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.LazyImageSeriesFrame;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.logicalimage.LogicalImageSeriesControls;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.logicalimage.LogicalImageSeriesDownloader;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.logicalimage.LogicalImageSeriesGridInitializer;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.logicalimage.LogicalImageSeriesModel;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.logicalimage.LogicalImageSeriesMovieControls;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.logicalimage.LogicalImageSeriesTimeAndDepthControls;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.ImageChannelStack;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;

public class LogicalImageSeriesGrid
extends LayoutContainer {
    private LogicalImageSeriesGridInitializer initializer;

    public LogicalImageSeriesGrid(LogicalImageSeriesGridInitializer initializer) {
        if (initializer == null) {
            throw new IllegalArgumentException("Initializer was null");
        }
        this.initializer = initializer;
        LogicalImageSeriesModel model = new LogicalImageSeriesModel(initializer.getChannelStackImages());
        List<LazyImageSeriesFrame> frames = this.createFrames(model);
        LogicalImageSeriesDownloader downloader = new LogicalImageSeriesDownloader(frames, initializer.getImageDownloadListener());
        LogicalImageSeriesControls controls = null;
        controls = model.isMatrixViewPossible() ? new LogicalImageSeriesTimeAndDepthControls(initializer.getViewContext(), initializer.getDisplayTypeId(), downloader, model) : new LogicalImageSeriesMovieControls(initializer.getViewContext(), initializer.getDisplayTypeId(), downloader, model);
        for (LazyImageSeriesFrame frame : frames) {
            controls.add((Widget)frame);
        }
        this.add((Component)controls);
    }

    private List<LazyImageSeriesFrame> createFrames(LogicalImageSeriesModel model) {
        ArrayList<LazyImageSeriesFrame> frames = new ArrayList<LazyImageSeriesFrame>();
        String sessionId = this.initializer.getViewContext().getModel().getSessionContext().getSessionID();
        for (List<ImageChannelStack> seriesPointStacks : model.getSortedChannelStackSeriesPoints()) {
            LazyImageSeriesFrame frame = new LazyImageSeriesFrame(seriesPointStacks, this.initializer.getChannelReferences(), sessionId, this.initializer.getImageSize().getWidth(), this.initializer.getImageSize().getHeight());
            frame.setImageClickHandler(this.initializer.getImageClickHandler());
            boolean isFirstFrame = frames.isEmpty();
            if (isFirstFrame) {
                frame.downloadImagesFromServer();
            }
            frame.setVisible(isFirstFrame);
            frames.add(frame);
        }
        return frames;
    }
}

