/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.utils;

import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.renderer.DateRenderer;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.DatasetReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class EntityTypeLabelUtils {
    public static final List<String> createDatasetLabels(List<DatasetReference> datasetReferences, boolean withFileType) {
        ArrayList<String> labels = new ArrayList<String>(datasetReferences.size());
        for (DatasetReference datasetReference : datasetReferences) {
            labels.add(EntityTypeLabelUtils.createDatasetLabel(datasetReference, withFileType, null, true));
        }
        return labels;
    }

    public static final List<String> createDatasetLabelsForFeatureVectors(List<DatasetReference> featureVectors, boolean withFileType) {
        HashMap<String, Integer> labelsSet = new HashMap<String, Integer>(featureVectors.size());
        ArrayList<String> labels = new ArrayList<String>(featureVectors.size());
        for (DatasetReference reference : featureVectors) {
            String label = EntityTypeLabelUtils.createDatasetLabel(reference, withFileType, reference.getAnalysisProcedure(), false);
            Integer count = 1;
            if (labelsSet.containsKey(label)) {
                count = (Integer)labelsSet.get(label) + 1;
            }
            labelsSet.put(label, count);
            labels.add(label);
        }
        int i = 0;
        for (DatasetReference reference : featureVectors) {
            String label = (String)labels.get(i);
            if ((Integer)labelsSet.get(label) > 1) {
                labels.set(i, EntityTypeLabelUtils.createDatasetLabel(reference, withFileType, reference.getAnalysisProcedure(), true));
            }
            ++i;
        }
        return labels;
    }

    public static String createDatasetLabel(DatasetReference datasetReference, boolean withFileType, String analysisProcedure, boolean withDatasetCode) {
        String registrationDate = EntityTypeLabelUtils.renderDate(datasetReference);
        return EntityTypeLabelUtils.createDatasetLabel(datasetReference, withFileType, registrationDate, analysisProcedure, withDatasetCode);
    }

    static String createDatasetLabel(DatasetReference datasetReference, boolean withFileType, String registrationDate, String analysisProcedure, boolean withDatasetCode) {
        String typeLabel = EntityTypeLabelUtils.getDatasetUserFriendlyTypeCode(datasetReference);
        String fileType = withFileType && datasetReference.getFileTypeCode() != null ? " (" + datasetReference.getFileTypeCode() + ")" : "";
        String analysisProcedureRendered = StringUtils.isBlank(analysisProcedure) ? "" : String.valueOf(analysisProcedure) + ", ";
        String additionalLabelPart = datasetReference.getLabelText() == null ? "" : String.valueOf(datasetReference.getLabelText()) + ", ";
        return String.valueOf(typeLabel) + fileType + ", " + additionalLabelPart + analysisProcedureRendered + registrationDate + (withDatasetCode ? ", " + datasetReference.getCode() : "");
    }

    private static String renderDate(DatasetReference datasetReference) {
        return DateRenderer.renderDate(datasetReference.getRegistrationDate(), "yyyy-MM-dd");
    }

    private static String getDatasetUserFriendlyTypeCode(DatasetReference datasetReference) {
        String datasetTypeCode = EntityTypeLabelUtils.getDatasetTypeCode(datasetReference);
        String label = EntityTypeLabelUtils.tryWithoutPrefix(datasetTypeCode, "HCS_ANALYSIS_WELL");
        if (StringUtils.isBlank(label)) {
            label = EntityTypeLabelUtils.tryWithoutPrefix(datasetTypeCode, "HCS_IMAGE_CONTAINER");
        }
        if (StringUtils.isBlank(label)) {
            label = EntityTypeLabelUtils.tryWithoutPrefix(datasetTypeCode, "HCS_IMAGE");
        }
        if (StringUtils.isBlank(label)) {
            label = EntityTypeLabelUtils.tryWithoutPrefix(datasetTypeCode, "HCS_");
        }
        if (StringUtils.isBlank(label)) {
            label = datasetTypeCode;
        }
        if (label.startsWith("_")) {
            label = label.substring(1);
        }
        return EntityTypeLabelUtils.formatAsTitle(label, true);
    }

    private static String tryWithoutPrefix(String datasetTypeCode, String prefix) {
        if (datasetTypeCode.startsWith(prefix)) {
            return datasetTypeCode.substring(prefix.length());
        }
        return null;
    }

    private static String getDatasetTypeCode(DatasetReference datasetReference) {
        return datasetReference.getEntityType().getCode();
    }

    public static String formatAsTitle(String text, boolean captalizeFirstLetter) {
        String label = captalizeFirstLetter ? String.valueOf(("" + text.charAt(0)).toUpperCase()) + text.substring(1).toLowerCase() : text.toLowerCase();
        return label.replace('_', ' ');
    }
}

