/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.utils;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.lang.StringEscapeUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolderWithProperties;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityPropertiesHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.util.Margins;
import com.extjs.gxt.ui.client.widget.Html;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.Text;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.extjs.gxt.ui.client.widget.layout.RowData;
import com.extjs.gxt.ui.client.widget.layout.TableData;
import com.extjs.gxt.ui.client.widget.layout.TableLayout;
import com.google.gwt.user.client.ui.Widget;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;

public class PropertiesUtil {
    public static String tryFindProperty(IEntityPropertiesHolder propertiesHolder, String propertyCode) {
        for (IEntityProperty property : propertiesHolder.getProperties()) {
            if (!property.getPropertyType().getCode().equalsIgnoreCase(propertyCode)) continue;
            return property.tryGetAsString();
        }
        return null;
    }

    public static int addProperties(IEntityInformationHolderWithProperties propertiesHolder, LayoutContainer panel, Map<String, String> additionalPropertiesOrNull, String ... excludedPropertyCodes) {
        LayoutContainer propertiesPanel = new LayoutContainer();
        propertiesPanel.setLayout((Layout)new TableLayout(3));
        Map<String, String> propertiesMap = PropertiesUtil.createSortedMap(propertiesHolder, excludedPropertyCodes, additionalPropertiesOrNull);
        int height = 0;
        for (Map.Entry<String, String> entry : propertiesMap.entrySet()) {
            PropertiesUtil.addProperty(propertiesPanel, entry.getKey(), entry.getValue());
            height += PropertiesUtil.getEstimatedHeight(entry.getValue());
        }
        panel.add((Widget)propertiesPanel);
        return height;
    }

    private static Map<String, String> createSortedMap(IEntityInformationHolderWithProperties propertiesHolder, String[] excludedPropertyCodes, Map<String, String> additionalPropertiesOrNull) {
        HashSet<String> excludedPropertyCodesSet = new HashSet<String>(Arrays.asList(excludedPropertyCodes));
        TreeMap<String, String> propertiesMap = new TreeMap<String, String>();
        for (IEntityProperty iEntityProperty : propertiesHolder.getProperties()) {
            String value;
            PropertyType propertyType = iEntityProperty.getPropertyType();
            if (excludedPropertyCodesSet.contains(propertyType.getCode()) || (value = iEntityProperty.tryGetAsString()) == null || value.length() <= 0) continue;
            propertiesMap.put(propertyType.getLabel(), value);
        }
        if (additionalPropertiesOrNull != null) {
            for (Map.Entry entry : additionalPropertiesOrNull.entrySet()) {
                propertiesMap.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return propertiesMap;
    }

    private static void addProperty(LayoutContainer propertiesPanel, String label, String value) {
        TableData labelLayout = new TableData(Style.HorizontalAlignment.RIGHT, Style.VerticalAlignment.TOP);
        labelLayout.setWidth("80px");
        propertiesPanel.add((Widget)new Html(String.valueOf(label) + ": "), (LayoutData)labelLayout);
        TableData spacerLayout = new TableData();
        spacerLayout.setWidth("5px");
        propertiesPanel.add((Widget)new Text(""), (LayoutData)spacerLayout);
        TableData valueLayout = new TableData(Style.HorizontalAlignment.LEFT, Style.VerticalAlignment.TOP);
        propertiesPanel.add((Widget)new Html(StringEscapeUtils.unescapeHtml(value)), (LayoutData)valueLayout);
    }

    private static int getEstimatedHeight(String text) {
        int charsPerLine = 150;
        return 15 * (text.length() / charsPerLine + 1);
    }

    public static Margins createHeaderInfoMargin() {
        return new Margins(3, 3, 10, 3);
    }

    public static RowData createHeaderTitleLayoutData() {
        return new RowData(-1.0, -1.0, new Margins(0, 0, 5, 0));
    }

    public static Html createHeaderTitle(String headingText) {
        Html headingWidget = new Html(headingText);
        headingWidget.setTagName("h1");
        return headingWidget;
    }
}

