/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.sample;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.VocabularyTermModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.AbstractRegistrationForm;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.ExperimentChooserField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.VocabularyTermSelectionWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.FieldUtil;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Vocabulary;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.sample.AbstractSampleBatchRegistrationForm;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.IScreeningClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.LibraryRegistrationInfo;
import com.extjs.gxt.ui.client.widget.form.ComboBox;
import com.extjs.gxt.ui.client.widget.form.FormPanel;
import com.extjs.gxt.ui.client.widget.form.SimpleComboBox;
import com.extjs.gxt.ui.client.widget.form.SimpleComboValue;
import com.extjs.gxt.ui.client.widget.form.TextField;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.user.client.ui.Widget;
import java.io.Serializable;

public final class LibrarySampleBatchRegistrationForm
extends AbstractSampleBatchRegistrationForm {
    private static final String PLATES = "Plates";
    private static final String SIRNAS_PLATES = "siRNAs + Plates";
    private static final String GENES_SIRNAS_PLATES = "Genes + siRNAs + Plates";
    private static final String SESSION_KEY = "qiagen-library-sample-batch-registration";
    private final ExperimentChooserField.ExperimentChooserFieldAdaptor experimentChooser;
    private final IViewContext<IScreeningClientServiceAsync> viewContext;
    private final PlateGeometrySelectionWidget plateGeometryField;
    private final SimpleComboBox<String> scopeField;
    private final TextField<String> emailField;
    private final SimpleComboBox<Separator> separatorField;

    public LibrarySampleBatchRegistrationForm(IViewContext<IScreeningClientServiceAsync> viewContext) {
        super(viewContext.getCommonViewContext(), SESSION_KEY);
        this.setResetButtonVisible(true);
        this.viewContext = viewContext;
        this.experimentChooser = ExperimentChooserField.create(viewContext.getMessage("experiment", new Object[0]), true, null, viewContext.getCommonViewContext());
        this.plateGeometryField = this.createPlateGeometryField();
        this.scopeField = this.createScopeField();
        this.separatorField = this.createSeparatorField();
        this.emailField = this.createEmailField(viewContext.getModel().getSessionContext().getUser().getUserEmail());
    }

    private TextField<String> createEmailField(String userEmail) {
        TextField field = new TextField();
        field.setAllowBlank(false);
        field.setFieldLabel("Email");
        FieldUtil.markAsMandatory(field);
        field.setValue((Object)userEmail);
        field.setValidateOnBlur(true);
        field.setRegex("^([a-zA-Z0-9_\\.\\-])+\\@(([a-zA-Z0-9\\-])+\\.)+([a-zA-Z0-9]{2,4})+$");
        field.getMessages().setRegexText("Expected email address format: user@domain.com");
        AbstractImagePrototype infoIcon = AbstractImagePrototype.create((ImageResource)this.viewContext.getImageBundle().getInfoIcon());
        FieldUtil.addInfoIcon(field, "All relevant notifications will be send to this email address", infoIcon.createImage());
        return field;
    }

    private SimpleComboBox<String> createScopeField() {
        SimpleComboBox options = new SimpleComboBox();
        options.add((Object)GENES_SIRNAS_PLATES);
        options.add((Object)SIRNAS_PLATES);
        options.add((Object)PLATES);
        options.setFieldLabel(this.viewContext.getMessage("register", new Object[0]));
        options.setTriggerAction(ComboBox.TriggerAction.ALL);
        options.setForceSelection(true);
        options.setEditable(false);
        options.setAllowBlank(false);
        options.setSimpleValue((Object)GENES_SIRNAS_PLATES);
        FieldUtil.markAsMandatory(options);
        return options;
    }

    private SimpleComboBox<Separator> createSeparatorField() {
        SimpleComboBox options = new SimpleComboBox();
        Separator[] separatorArray = Separator.values();
        int n = separatorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Separator separator = separatorArray[n2];
            options.add((Object)separator);
            ++n2;
        }
        options.setFieldLabel(this.viewContext.getMessage("separator", new Object[0]));
        options.setTriggerAction(ComboBox.TriggerAction.ALL);
        options.setForceSelection(true);
        options.setEditable(false);
        options.setAllowBlank(false);
        options.setSimpleValue((Object)Separator.COMMA);
        FieldUtil.markAsMandatory(options);
        return options;
    }

    @Override
    protected void save() {
        ExperimentIdentifier experiment = this.experimentChooser.tryToGetValue();
        VocabularyTermModel value = (VocabularyTermModel)this.plateGeometryField.getValue();
        String plateGeometry = value == null ? null : value.getTerm().getCode();
        String userEmail = (String)this.emailField.getValue();
        char separator = this.extractSeparatorCharacter();
        LibraryRegistrationInfo.RegistrationScope registrationScope = this.extractRegistrationScope();
        LibraryRegistrationInfo libraryInfo = new LibraryRegistrationInfo().setSessionKey(this.getSessionKey()).setExperiment(experiment.getIdentifier()).setPlateGeometry(plateGeometry).setUserEmail(userEmail).setScope(registrationScope).setSeparator(separator);
        this.viewContext.getService().registerLibrary(libraryInfo, new RegisterSamplesCallback(this.viewContext));
        this.infoBox.displayInfo("Data preprocessing started. Please wait...");
    }

    private char extractSeparatorCharacter() {
        Separator separator = (Separator)((SimpleComboValue)this.separatorField.getValue()).getValue();
        return separator.asChar();
    }

    private LibraryRegistrationInfo.RegistrationScope extractRegistrationScope() {
        String value = (String)((SimpleComboValue)this.scopeField.getValue()).getValue();
        if (value.equals(GENES_SIRNAS_PLATES)) {
            return LibraryRegistrationInfo.RegistrationScope.GENES_SIRNAS_PLATES;
        }
        if (value.equals(SIRNAS_PLATES)) {
            return LibraryRegistrationInfo.RegistrationScope.SIRNAS_PLATES;
        }
        if (value.equals(PLATES)) {
            return LibraryRegistrationInfo.RegistrationScope.PLATES;
        }
        return null;
    }

    @Override
    protected void addSpecificFormFields(FormPanel form) {
        form.add((Widget)this.experimentChooser.getChooserField());
        form.add((Widget)this.plateGeometryField);
        form.add(this.emailField);
        form.add(this.scopeField);
        form.add(this.separatorField);
    }

    private PlateGeometrySelectionWidget createPlateGeometryField() {
        PlateGeometrySelectionWidget field = new PlateGeometrySelectionWidget(this.viewContext);
        field.setFieldLabel("Plate Geometry");
        FieldUtil.markAsMandatory(field);
        return field;
    }

    private static final class PlateGeometrySelectionWidget
    extends VocabularyTermSelectionWidget {
        PlateGeometrySelectionWidget(IViewContext<IScreeningClientServiceAsync> viewContext) {
            super("plateGeometry", "plateGeometry", false, null, viewContext, null, null);
            this.setAllowBlank(false);
            this.setForceSelection(true);
            viewContext.getService().getPlateGeometryVocabulary((AsyncCallback<Vocabulary>)new AbstractAsyncCallback<Vocabulary>(viewContext){

                @Override
                protected void process(Vocabulary vocabulary) {
                    PlateGeometrySelectionWidget.this.setVocabulary(vocabulary);
                }
            });
        }
    }

    private final class RegisterSamplesCallback
    extends AbstractRegistrationForm.AbstractRegistrationCallback<Void> {
        RegisterSamplesCallback(IViewContext<IScreeningClientServiceAsync> viewContext) {
            super(viewContext);
        }

        @Override
        protected String createSuccessfullRegistrationInfo(Void result) {
            return this.viewContext.getMessage("import_scheduled", LibrarySampleBatchRegistrationForm.this.emailField.getValue());
        }
    }

    public static enum Separator implements Serializable
    {
        TAB('\t'),
        COMMA(','),
        SEMICOLON(';');

        final char character;

        private Separator(char character) {
            this.character = character;
        }

        public char asChar() {
            return this.character;
        }

        public String toString() {
            return String.valueOf(this.name()) + " (" + this.character + ")";
        }
    }
}

