/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.client.dto;

import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BasicProjectIdentifier;

public class ExperimentIdentifierSearchCriteria {
    private final String experimentIdentifierOrNull;
    private final BasicProjectIdentifier projectOrNull;
    private final boolean restrictGlobalScopeLinkToProject;

    public static ExperimentIdentifierSearchCriteria createSearchAll() {
        return new ExperimentIdentifierSearchCriteria(null, null, false);
    }

    public static ExperimentIdentifierSearchCriteria createProjectScope(BasicProjectIdentifier project) {
        return new ExperimentIdentifierSearchCriteria(null, project, false);
    }

    public static ExperimentIdentifierSearchCriteria createExperimentScope(String experimentIdentifier, boolean restrictGlobalScopeLinkToProject) {
        return new ExperimentIdentifierSearchCriteria(experimentIdentifier, null, restrictGlobalScopeLinkToProject);
    }

    private ExperimentIdentifierSearchCriteria(String experimentIdentifierOrNull, BasicProjectIdentifier projectOrNull, boolean restrictGlobalScopeLinkToProject) {
        this.experimentIdentifierOrNull = experimentIdentifierOrNull;
        this.projectOrNull = projectOrNull;
        this.restrictGlobalScopeLinkToProject = restrictGlobalScopeLinkToProject;
    }

    public String tryGetExperimentIdentifier() {
        return this.experimentIdentifierOrNull;
    }

    public boolean getRestrictGlobalSearchLinkToProject() {
        return this.restrictGlobalScopeLinkToProject;
    }

    public BasicProjectIdentifier tryGetProject() {
        return this.projectOrNull;
    }

    public boolean searchAllExperiments() {
        return StringUtils.isBlank(this.experimentIdentifierOrNull) && this.projectOrNull == null;
    }
}

