/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.server.dataaccess;

import ch.rinn.restrictions.Friend;
import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.LongArrayMapper;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.StringArrayMapper;
import ch.systemsx.cisd.openbis.plugin.screening.server.dataaccess.AnalysisProcedureResult;
import ch.systemsx.cisd.openbis.plugin.screening.server.dataaccess.BasicWellContentQueryResult;
import ch.systemsx.cisd.openbis.plugin.screening.server.dataaccess.ExperimentReferenceQueryResult;
import ch.systemsx.cisd.openbis.plugin.screening.server.dataaccess.PlateGeometryContainer;
import ch.systemsx.cisd.openbis.plugin.screening.server.dataaccess.WellContentQueryResult;
import java.util.List;
import net.lemnik.eodsql.BaseQuery;
import net.lemnik.eodsql.DataIterator;
import net.lemnik.eodsql.Select;
import net.lemnik.eodsql.TypeMapper;

@Private
@Friend(toClasses={WellContentQueryResult.class, BasicWellContentQueryResult.class})
public interface IScreeningQuery
extends BaseQuery {
    public static final int FETCH_SIZE = 1000;
    public static final String WELLS_FOR_MATERIAL_ID_SELECT = "select       well.id as well_id,      well.perm_id as well_perm_id,      well.code as well_code,      well_type.code as well_type_code,      pl.id as plate_id,      pl.perm_id as plate_perm_id,      pl.code as plate_code,      pl_type.code as plate_type_code,      exp.id as exp_id,      exp.code as exp_code,      exp.perm_id as exp_perm_id,      exp_type.code as exp_type_code,      projects.code as proj_code,      spaces.code as space_code,      well_material.id as material_content_id from materials well_material       join sample_properties well_props on well_props.mate_prop_id = well_material.id      join samples well on  well_props.samp_id = well.id      join samples pl on well.samp_id_part_of = pl.id      join experiments exp on pl.expe_id = exp.id        join experiment_types exp_type on exp.exty_id = exp_type.id        join projects on exp.proj_id = projects.id           join spaces on projects.space_id = spaces.id        join sample_types pl_type on pl.saty_id = pl_type.id         join sample_types well_type on well.saty_id = well_type.id        join material_types well_material_type on well_material.maty_id = well_material_type.id";
    public static final String MINIMAL_WELLS_FOR_MATERIAL_ID_QUERY = "select      well.code as well_code,      pl.perm_id as plate_perm_id,      exp.perm_id as exp_perm_id,      well_props.mate_prop_id as material_content_id from experiments exp      join samples pl on pl.expe_id = exp.id      join samples well on well.samp_id_part_of = pl.id      join sample_properties well_props on well_props.samp_id = well.id      join materials well_material on well_props.mate_prop_id = well_material.id      join material_types well_material_type on well_material.maty_id = well_material_type.id where pl.samp_id_part_of is null ";
    public static final String EXPERIMENTS_WITH_MATERIAL_SELECT = "         select distinct                       exp.id as exp_id,                              exp.code as exp_code,                          exp.perm_id as exp_perm_id,                    exp_type.code as exp_type_code,                projects.code as proj_code,                    spaces.code as space_code                from materials well_material      join sample_properties well_props on well_props.mate_prop_id = well_material.id       join samples well on well_props.samp_id = well.id      join samples plate on well.samp_id_part_of = plate.id      join experiments exp on plate.expe_id = exp.id      join experiment_types exp_type on exp.exty_id = exp_type.id       join projects on exp.proj_id = projects.id           join spaces on projects.space_id = spaces.id  ";
    public static final String ANALYSIS_PROCEDURE_SELECT = "select distinct        ds_props.value as analysisProcedure, ds_type.code as datasetTypeCode  from experiments exp        join data ds on ds.expe_id = exp.id        join samples plate on plate.id = ds.samp_id        join samples well on well.samp_id_part_of = plate.id        join data_set_types ds_type on ds.dsty_id = ds_type.id        join data_set_type_property_types  dst_pt on dst_pt.dsty_id = ds_type.id        left outer join data_set_properties ds_props on ds_props.ds_id = ds.id and ds_props.dstpt_id = dst_pt.id  where        dst_pt.prty_id = (select id from property_types where code='ANALYSIS_PROCEDURE' and is_internal_namespace=true)";
    public static final String SELECT_DSS_CODES_FOR_EXPERIMENT = "  select distinct datastore.code       from experiments exp            join data dataset on dataset.expe_id = exp.id            join data_stores datastore on dataset.dast_id = datastore.id       where exp.id = ?{1}";

    @Select(sql="select       well.id as well_id,      well.perm_id as well_perm_id,      well.code as well_code,      well_type.code as well_type_code,      pl.id as plate_id,      pl.perm_id as plate_perm_id,      pl.code as plate_code,      pl_type.code as plate_type_code,      exp.id as exp_id,      exp.code as exp_code,      exp.perm_id as exp_perm_id,      exp_type.code as exp_type_code,      projects.code as proj_code,      spaces.code as space_code,      well_material.id as material_content_id from materials well_material       join sample_properties well_props on well_props.mate_prop_id = well_material.id      join samples well on  well_props.samp_id = well.id      join samples pl on well.samp_id_part_of = pl.id      join experiments exp on pl.expe_id = exp.id        join experiment_types exp_type on exp.exty_id = exp_type.id        join projects on exp.proj_id = projects.id           join spaces on projects.space_id = spaces.id        join sample_types pl_type on pl.saty_id = pl_type.id         join sample_types well_type on well.saty_id = well_type.id        join material_types well_material_type on well_material.maty_id = well_material_type.id where well_material.id = ?{1} and exp.id = ?{2}")
    public DataIterator<WellContentQueryResult> getPlateLocationsForMaterialId(long var1, long var3);

    @Select(sql="select       well.id as well_id,      well.perm_id as well_perm_id,      well.code as well_code,      well_type.code as well_type_code,      pl.id as plate_id,      pl.perm_id as plate_perm_id,      pl.code as plate_code,      pl_type.code as plate_type_code,      exp.id as exp_id,      exp.code as exp_code,      exp.perm_id as exp_perm_id,      exp_type.code as exp_type_code,      projects.code as proj_code,      spaces.code as space_code,      well_material.id as material_content_id from materials well_material       join sample_properties well_props on well_props.mate_prop_id = well_material.id      join samples well on  well_props.samp_id = well.id      join samples pl on well.samp_id_part_of = pl.id      join experiments exp on pl.expe_id = exp.id        join experiment_types exp_type on exp.exty_id = exp_type.id        join projects on exp.proj_id = projects.id           join spaces on projects.space_id = spaces.id        join sample_types pl_type on pl.saty_id = pl_type.id         join sample_types well_type on well.saty_id = well_type.id        join material_types well_material_type on well_material.maty_id = well_material_type.id where well_material.id = ?{1} and spaces.code = ?{2} and projects.code = ?{3}")
    public DataIterator<WellContentQueryResult> getPlateLocationsForMaterialId(long var1, String var3, String var4);

    @Select(sql="select       well.id as well_id,      well.perm_id as well_perm_id,      well.code as well_code,      well_type.code as well_type_code,      pl.id as plate_id,      pl.perm_id as plate_perm_id,      pl.code as plate_code,      pl_type.code as plate_type_code,      exp.id as exp_id,      exp.code as exp_code,      exp.perm_id as exp_perm_id,      exp_type.code as exp_type_code,      projects.code as proj_code,      spaces.code as space_code,      well_material.id as material_content_id from materials well_material       join sample_properties well_props on well_props.mate_prop_id = well_material.id      join samples well on  well_props.samp_id = well.id      join samples pl on well.samp_id_part_of = pl.id      join experiments exp on pl.expe_id = exp.id        join experiment_types exp_type on exp.exty_id = exp_type.id        join projects on exp.proj_id = projects.id           join spaces on projects.space_id = spaces.id        join sample_types pl_type on pl.saty_id = pl_type.id         join sample_types well_type on well.saty_id = well_type.id        join material_types well_material_type on well_material.maty_id = well_material_type.id where well_material.id = ?{1}")
    public DataIterator<WellContentQueryResult> getPlateLocationsForMaterialId(long var1);

    @Select(sql="select       well.id as well_id,      well.perm_id as well_perm_id,      well.code as well_code,      well_type.code as well_type_code,      pl.id as plate_id,      pl.perm_id as plate_perm_id,      pl.code as plate_code,      pl_type.code as plate_type_code,      exp.id as exp_id,      exp.code as exp_code,      exp.perm_id as exp_perm_id,      exp_type.code as exp_type_code,      projects.code as proj_code,      spaces.code as space_code,      well_material.id as material_content_id from materials well_material       join sample_properties well_props on well_props.mate_prop_id = well_material.id      join samples well on  well_props.samp_id = well.id      join samples pl on well.samp_id_part_of = pl.id      join experiments exp on pl.expe_id = exp.id        join experiment_types exp_type on exp.exty_id = exp_type.id        join projects on exp.proj_id = projects.id           join spaces on projects.space_id = spaces.id        join sample_types pl_type on pl.saty_id = pl_type.id         join sample_types well_type on well.saty_id = well_type.id        join material_types well_material_type on well_material.maty_id = well_material_type.id where well_material.id = ?{1} and projects.id = ?{2}")
    public DataIterator<WellContentQueryResult> getPlateLocationsForMaterialAndProjectIds(long var1, long var3);

    @Select(sql="select       well.id as well_id,      well.perm_id as well_perm_id,      well.code as well_code,      well_type.code as well_type_code,      pl.id as plate_id,      pl.perm_id as plate_perm_id,      pl.code as plate_code,      pl_type.code as plate_type_code,      exp.id as exp_id,      exp.code as exp_code,      exp.perm_id as exp_perm_id,      exp_type.code as exp_type_code,      projects.code as proj_code,      spaces.code as space_code,      well_material.id as material_content_id from materials well_material       join sample_properties well_props on well_props.mate_prop_id = well_material.id      join samples well on  well_props.samp_id = well.id      join samples pl on well.samp_id_part_of = pl.id      join experiments exp on pl.expe_id = exp.id        join experiment_types exp_type on exp.exty_id = exp_type.id        join projects on exp.proj_id = projects.id           join spaces on projects.space_id = spaces.id        join sample_types pl_type on pl.saty_id = pl_type.id         join sample_types well_type on well.saty_id = well_type.id        join material_types well_material_type on well_material.maty_id = well_material_type.id where well_material.id = any(?{1}) and well_material_type.code = any(?{2}) and spaces.code = ?{3} and projects.code = ?{4}", parameterBindings={LongArrayMapper.class, StringArrayMapper.class, TypeMapper.class, TypeMapper.class})
    public DataIterator<WellContentQueryResult> getPlateLocationsForMaterialCodesInProject(long[] var1, String[] var2, String var3, String var4);

    @Select(sql="select       well.id as well_id,      well.perm_id as well_perm_id,      well.code as well_code,      well_type.code as well_type_code,      pl.id as plate_id,      pl.perm_id as plate_perm_id,      pl.code as plate_code,      pl_type.code as plate_type_code,      exp.id as exp_id,      exp.code as exp_code,      exp.perm_id as exp_perm_id,      exp_type.code as exp_type_code,      projects.code as proj_code,      spaces.code as space_code,      well_material.id as material_content_id from materials well_material       join sample_properties well_props on well_props.mate_prop_id = well_material.id      join samples well on  well_props.samp_id = well.id      join samples pl on well.samp_id_part_of = pl.id      join experiments exp on pl.expe_id = exp.id        join experiment_types exp_type on exp.exty_id = exp_type.id        join projects on exp.proj_id = projects.id           join spaces on projects.space_id = spaces.id        join sample_types pl_type on pl.saty_id = pl_type.id         join sample_types well_type on well.saty_id = well_type.id        join material_types well_material_type on well_material.maty_id = well_material_type.id where well_material.id = any(?{1}) and well_material_type.code = any(?{2}) and exp.id = ?{3}", parameterBindings={LongArrayMapper.class, StringArrayMapper.class, TypeMapper.class})
    public DataIterator<WellContentQueryResult> getPlateLocationsForMaterialCodes(long[] var1, String[] var2, long var3);

    @Select(sql="select       well.id as well_id,      well.perm_id as well_perm_id,      well.code as well_code,      well_type.code as well_type_code,      pl.id as plate_id,      pl.perm_id as plate_perm_id,      pl.code as plate_code,      pl_type.code as plate_type_code,      exp.id as exp_id,      exp.code as exp_code,      exp.perm_id as exp_perm_id,      exp_type.code as exp_type_code,      projects.code as proj_code,      spaces.code as space_code,      well_material.id as material_content_id from materials well_material       join sample_properties well_props on well_props.mate_prop_id = well_material.id      join samples well on  well_props.samp_id = well.id      join samples pl on well.samp_id_part_of = pl.id      join experiments exp on pl.expe_id = exp.id        join experiment_types exp_type on exp.exty_id = exp_type.id        join projects on exp.proj_id = projects.id           join spaces on projects.space_id = spaces.id        join sample_types pl_type on pl.saty_id = pl_type.id         join sample_types well_type on well.saty_id = well_type.id        join material_types well_material_type on well_material.maty_id = well_material_type.id where well_material.id = any(?{1}) and well_material_type.code = any(?{2})", parameterBindings={LongArrayMapper.class, StringArrayMapper.class})
    public DataIterator<WellContentQueryResult> getPlateLocationsForMaterialCodes(long[] var1, String[] var2);

    @Select(sql="select       well.code as well_code,      well_material.code as material_content_code from samples well   join samples pl on pl.id = well.samp_id_part_of   join sample_properties well_props on well.id = well_props.samp_id   join materials well_material on well_props.mate_prop_id = well_material.id   join material_types well_material_type on well_material.maty_id = well_material_type.id where well_material_type.code=?{2} and pl.perm_id=?{1}", fetchSize=1000)
    public DataIterator<WellContentQueryResult> getPlateMappingForMaterialType(String var1, String var2);

    @Select(sql="select       well.code as well_code,      well_material_type.code as material_content_type_code,      well_material.code as material_content_code from samples well   join samples pl on pl.id = well.samp_id_part_of   join sample_properties well_props on well.id = well_props.samp_id   join materials well_material on well_props.mate_prop_id = well_material.id   join material_types well_material_type on well_material.maty_id = well_material_type.id where pl.perm_id=?{1} order by material_content_type_code", fetchSize=1000)
    public DataIterator<WellContentQueryResult> getPlateMapping(String var1);

    @Select(sql="select       well.code as well_code,      well_material.code as material_content_code from samples well   join samples pl on pl.id = well.samp_id_part_of   join spaces sp on pl.space_id = sp.id   join sample_properties well_props on well.id = well_props.samp_id   join materials well_material on well_props.mate_prop_id = well_material.id   join material_types well_material_type on well_material.maty_id = well_material_type.id where well_material_type.code = ?{3} and pl.code = ?{2} and sp.code = ?{1}", fetchSize=1000)
    public DataIterator<WellContentQueryResult> getPlateMappingForMaterialType(String var1, String var2, String var3);

    @Select(sql="select      well.code as well_code,      pl.perm_id as plate_perm_id,      exp.perm_id as exp_perm_id,      well_props.mate_prop_id as material_content_id from experiments exp      join samples pl on pl.expe_id = exp.id      join samples well on well.samp_id_part_of = pl.id      join sample_properties well_props on well_props.samp_id = well.id      join materials well_material on well_props.mate_prop_id = well_material.id      join material_types well_material_type on well_material.maty_id = well_material_type.id where pl.samp_id_part_of is null  and exp.id = any(?{1})       and well_material_type.code similar to ?{2}", parameterBindings={LongArrayMapper.class, TypeMapper.class}, fetchSize=1000)
    public List<BasicWellContentQueryResult> getPlateLocationsForExperiment(long[] var1, String var2);

    @Select(sql="select      well.code as well_code,      pl.perm_id as plate_perm_id,      exp.perm_id as exp_perm_id,      well_props.mate_prop_id as material_content_id from experiments exp      join samples pl on pl.expe_id = exp.id      join samples well on well.samp_id_part_of = pl.id      join sample_properties well_props on well_props.samp_id = well.id      join materials well_material on well_props.mate_prop_id = well_material.id      join material_types well_material_type on well_material.maty_id = well_material_type.id where pl.samp_id_part_of is null  and exp.id = any(?{1})       and well_material.id = ?{2}", parameterBindings={LongArrayMapper.class, TypeMapper.class}, fetchSize=1000)
    public List<BasicWellContentQueryResult> getPlateLocationsForExperiment(long[] var1, long var2);

    @Select(sql="select       well.code as well_code,      well_material_type.code as material_content_type_code,      well_material.code as material_content_code from samples well   join samples pl on pl.id = well.samp_id_part_of   join spaces sp on pl.space_id = sp.id   join sample_properties well_props on well.id = well_props.samp_id   join materials well_material on well_props.mate_prop_id = well_material.id   join material_types well_material_type on well_material.maty_id = well_material_type.id where sp.code = ?{1} and pl.code = ?{2} order by material_content_type_code", fetchSize=1000)
    public DataIterator<WellContentQueryResult> getPlateMapping(String var1, String var2);

    @Select(sql="select space.code as space_code, pl.code as plate_code, cvte.code as plate_geometry       from sample_properties sp          join samples pl on pl.id = sp.samp_id          join controlled_vocabulary_terms cvte on cvte.id = sp.cvte_id          join sample_type_property_types stpt on stpt.id = sp.stpt_id          join property_types pt on pt.id = stpt.prty_id          join spaces space on pl.space_id = space.id      where pt.code = 'PLATE_GEOMETRY'          and pt.is_internal_namespace = true and pl.perm_id = ?{1}")
    public PlateGeometryContainer tryGetPlateGeometry(String var1);

    @Select(sql="select pl.perm_id, cvte.code as plate_geometry       from sample_properties sp          join samples pl on pl.id = sp.samp_id          join controlled_vocabulary_terms cvte on cvte.id = sp.cvte_id          join sample_type_property_types stpt on stpt.id = sp.stpt_id          join property_types pt on pt.id = stpt.prty_id          join spaces space on pl.space_id = space.id      where pt.code = 'PLATE_GEOMETRY'          and pt.is_internal_namespace = true and space.code = ?{1} and pl.code = ?{2}")
    public PlateGeometryContainer tryGetPlateGeometry(String var1, String var2);

    @Select(sql="SELECT distinct well_material.id                  FROM samples pl                                 JOIN samples well ON well.samp_id_part_of = pl.id      JOIN sample_properties well_props ON well_props.samp_id = well.id      JOIN materials well_material ON well_material.id = well_props.mate_prop_id     WHERE pl.expe_id = ?{1}                          AND well_material.maty_id = ?{2}", fetchSize=1000)
    public DataIterator<Long> getMaterialsForExperimentWells(long var1, long var3);

    @Select(sql="         select distinct                       exp.id as exp_id,                              exp.code as exp_code,                          exp.perm_id as exp_perm_id,                    exp_type.code as exp_type_code,                projects.code as proj_code,                    spaces.code as space_code                from materials well_material      join sample_properties well_props on well_props.mate_prop_id = well_material.id       join samples well on well_props.samp_id = well.id      join samples plate on well.samp_id_part_of = plate.id      join experiments exp on plate.expe_id = exp.id      join experiment_types exp_type on exp.exty_id = exp_type.id       join projects on exp.proj_id = projects.id           join spaces on projects.space_id = spaces.id   where well_material.id = ?{1}")
    public List<ExperimentReferenceQueryResult> getExperimentsWithMaterial(long var1);

    @Select(sql="         select distinct                       exp.id as exp_id,                              exp.code as exp_code,                          exp.perm_id as exp_perm_id,                    exp_type.code as exp_type_code,                projects.code as proj_code,                    spaces.code as space_code                from materials well_material      join sample_properties well_props on well_props.mate_prop_id = well_material.id       join samples well on well_props.samp_id = well.id      join samples plate on well.samp_id_part_of = plate.id      join experiments exp on plate.expe_id = exp.id      join experiment_types exp_type on exp.exty_id = exp_type.id       join projects on exp.proj_id = projects.id           join spaces on projects.space_id = spaces.id   where well_material.id = ?{1} and exp.proj_id = ?{2}")
    public List<ExperimentReferenceQueryResult> getExperimentsWithMaterial(long var1, long var3);

    @Select(sql="select distinct        ds_props.value as analysisProcedure, ds_type.code as datasetTypeCode  from experiments exp        join data ds on ds.expe_id = exp.id        join samples plate on plate.id = ds.samp_id        join samples well on well.samp_id_part_of = plate.id        join data_set_types ds_type on ds.dsty_id = ds_type.id        join data_set_type_property_types  dst_pt on dst_pt.dsty_id = ds_type.id        left outer join data_set_properties ds_props on ds_props.ds_id = ds.id and ds_props.dstpt_id = dst_pt.id  where        dst_pt.prty_id = (select id from property_types where code='ANALYSIS_PROCEDURE' and is_internal_namespace=true)")
    public List<AnalysisProcedureResult> listAllAnalysisProcedures();

    @Select(sql="select distinct        ds_props.value as analysisProcedure, ds_type.code as datasetTypeCode  from experiments exp        join data ds on ds.expe_id = exp.id        join samples plate on plate.id = ds.samp_id        join samples well on well.samp_id_part_of = plate.id        join data_set_types ds_type on ds.dsty_id = ds_type.id        join data_set_type_property_types  dst_pt on dst_pt.dsty_id = ds_type.id        left outer join data_set_properties ds_props on ds_props.ds_id = ds.id and ds_props.dstpt_id = dst_pt.id  where        dst_pt.prty_id = (select id from property_types where code='ANALYSIS_PROCEDURE' and is_internal_namespace=true) and exp.id = ?{1}")
    public List<AnalysisProcedureResult> listAnalysisProceduresForExperiment(long var1);

    @Select(sql="  select distinct datastore.code       from experiments exp            join data dataset on dataset.expe_id = exp.id            join data_stores datastore on dataset.dast_id = datastore.id       where exp.id = ?{1}")
    public List<String> listDataStoreCodesForExperiment(long var1);
}

