/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.shared.imaging;

import ch.systemsx.cisd.common.collection.IKeyExtractor;
import ch.systemsx.cisd.common.collection.TableMap;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.CodeAndLabel;
import ch.systemsx.cisd.openbis.generic.shared.basic.utils.GroupByMap;
import ch.systemsx.cisd.openbis.generic.shared.basic.utils.IGroupKeyExtractor;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.FeatureVectorDatasetWellReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.WellPosition;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.FeatureValue;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.FeatureVectorValues;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellFeatureVectorReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellLocation;
import ch.systemsx.cisd.openbis.plugin.screening.shared.dto.FeatureTableRow;
import ch.systemsx.cisd.openbis.plugin.screening.shared.dto.PlateFeatureValues;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.FeatureVocabularyTermsMap;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.AbstractImgIdentifiable;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.IImagingReadonlyQueryDAO;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ImgAnalysisDatasetDTO;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ImgContainerDTO;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ImgFeatureDefDTO;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ImgFeatureValuesDTO;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ImgFeatureVocabularyTermDTO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class FeatureVectorLoader {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, FeatureVectorLoader.class);
    private final IImagingReadonlyQueryDAO dao;
    private final IMetadataProvider metadataProviderOrNull;
    private final List<DatasetFeaturesBundle> bundles;
    private final Map<CodeAndLabel, Integer> featureCodeLabelToIndexMap;
    private final Set<String> featureCodes;
    private final boolean useAllFeatures;
    private CodeAndLabel[] codesAndLabels;

    public static WellFeatureCollection<FeatureTableRow> fetchWellFeatures(List<FeatureVectorDatasetWellReference> references, List<String> featureCodes, IImagingReadonlyQueryDAO dao, IMetadataProvider metadataProviderOrNull) {
        FeatureVectorLoader builder = new FeatureVectorLoader(featureCodes, dao, metadataProviderOrNull);
        Set<String> datasetCodes = FeatureVectorLoader.extractDatasetCodes(references);
        builder.addFeatureVectorsOfDataSetsOrDie(datasetCodes);
        List<FeatureTableRow> features = builder.createFeatureTableRows(references);
        return new WellFeatureCollection<FeatureTableRow>(features, builder.getCodesAndLabels());
    }

    public static WellFeatureCollection<FeatureVectorValues> fetchWellFeatureCollection(List<String> datasetCodes, List<String> featureCodes, IImagingReadonlyQueryDAO dao, IMetadataProvider provider) {
        WellFeatureCollection<FeatureTableRow> features = FeatureVectorLoader.fetchDatasetFeatures(datasetCodes, featureCodes, dao, provider);
        return FeatureVectorLoader.asFeatureVectorValues(features);
    }

    private static WellFeatureCollection<FeatureVectorValues> asFeatureVectorValues(WellFeatureCollection<FeatureTableRow> featureRowsCollection) {
        List<FeatureTableRow> featureRows = featureRowsCollection.getFeatures();
        ArrayList<FeatureVectorValues> fvs = new ArrayList<FeatureVectorValues>();
        for (FeatureTableRow row : featureRows) {
            fvs.add(new FeatureVectorValues(row));
        }
        return new WellFeatureCollection<FeatureVectorValues>(fvs, featureRowsCollection.getFeatureCodesAndLabels());
    }

    public static WellFeatureCollection<FeatureTableRow> fetchDatasetFeatures(List<String> datasetCodes, List<String> featureCodes, IImagingReadonlyQueryDAO dao, IMetadataProvider metadataProviderOrNull) {
        FeatureVectorLoader builder = new FeatureVectorLoader(featureCodes, dao, metadataProviderOrNull);
        builder.addFeatureVectorsOfDataSetsOrDie(datasetCodes);
        List<FeatureTableRow> features = builder.createFeatureTableRows();
        return new WellFeatureCollection<FeatureTableRow>(features, builder.getCodesAndLabels());
    }

    public static WellFeatureCollection<FeatureVectorValues> fetchWellFeatureValuesIfPossible(List<WellFeatureVectorReference> references, IImagingReadonlyQueryDAO dao, IMetadataProvider metadataProvider) {
        FeatureVectorLoader builder = new FeatureVectorLoader(new ArrayList<String>(), dao, metadataProvider);
        Set<String> datasetCodes = FeatureVectorLoader.extractDatasetCodesFromSimpleReferences(references);
        builder.addFeatureVectorsOfDataSetsIfPossible(datasetCodes);
        List<FeatureVectorValues> features = builder.createFeatureVectorValuesIfPossible(references);
        return new WellFeatureCollection<FeatureVectorValues>(features, builder.getCodesAndLabels());
    }

    private void addFeatureVectorsOfDataSetsIfPossible(Collection<String> datasetCodes) {
        List<ImgAnalysisDatasetDTO> dataSets = this.listAnalysisDatasetsByPermId(datasetCodes);
        if (dataSets.size() != datasetCodes.size()) {
            operationLog.warn((Object)this.createUnknownDatasetMessage(datasetCodes, dataSets));
        }
        this.addFeatureVectorsOfDataSets(dataSets);
    }

    private String createUnknownDatasetMessage(Collection<String> requestedDatasetCodes, List<ImgAnalysisDatasetDTO> existingDataSets) {
        return String.format("Some of the datasets are unknown! Requested datasets: %s. Found datasets: %s.", requestedDatasetCodes, existingDataSets);
    }

    private static Set<String> extractDatasetCodesFromSimpleReferences(List<WellFeatureVectorReference> references) {
        HashSet<String> datasetCodes = new HashSet<String>();
        for (WellFeatureVectorReference ref : references) {
            datasetCodes.add(ref.getDatasetCode());
        }
        return datasetCodes;
    }

    private static Set<String> extractDatasetCodes(List<FeatureVectorDatasetWellReference> references) {
        HashSet<String> datasetCodes = new HashSet<String>();
        for (FeatureVectorDatasetWellReference ref : references) {
            datasetCodes.add(ref.getDatasetCode());
        }
        return datasetCodes;
    }

    FeatureVectorLoader(List<String> featureCodes, IImagingReadonlyQueryDAO dao, IMetadataProvider metadataProviderOrNull) {
        this.dao = dao;
        this.metadataProviderOrNull = metadataProviderOrNull;
        this.bundles = new ArrayList<DatasetFeaturesBundle>();
        this.featureCodeLabelToIndexMap = new LinkedHashMap<CodeAndLabel, Integer>();
        this.featureCodes = new LinkedHashSet<String>(featureCodes);
        this.useAllFeatures = featureCodes.isEmpty();
    }

    void addFeatureVectorsOfDataSetsOrDie(Collection<String> datasetCodes) {
        List<ImgAnalysisDatasetDTO> dataSets = this.listAnalysisDatasetsByPermId(datasetCodes);
        if (dataSets.size() != datasetCodes.size()) {
            throw new UserFailureException(this.createUnknownDatasetMessage(datasetCodes, dataSets));
        }
        this.addFeatureVectorsOfDataSets(dataSets);
    }

    private List<ImgAnalysisDatasetDTO> listAnalysisDatasetsByPermId(Collection<String> datasetCodes) {
        LinkedList<String> allCodes = new LinkedList<String>(datasetCodes);
        HashMap<String, String> containedToContainer = new HashMap<String, String>();
        if (this.metadataProviderOrNull != null) {
            for (String code : datasetCodes) {
                List<String> containedDataSetIds = this.metadataProviderOrNull.tryGetContainedDatasets(code);
                for (String contained : containedDataSetIds) {
                    containedToContainer.put(contained, code);
                }
                allCodes.addAll(containedDataSetIds);
            }
        }
        List<ImgAnalysisDatasetDTO> list = this.dao.listAnalysisDatasetsByPermId(allCodes.toArray(new String[0]));
        for (ImgAnalysisDatasetDTO imgAnalysisDatasetDTO : list) {
            imgAnalysisDatasetDTO.setDataSetContainerId((String)containedToContainer.get(imgAnalysisDatasetDTO.getPermId()));
        }
        return list;
    }

    void addFeatureVectorsOfDataSets(List<ImgAnalysisDatasetDTO> datasets) {
        DatasetFeatureDefinitionCachedLister lister = new DatasetFeatureDefinitionCachedLister(datasets, this.featureCodes, this.useAllFeatures, this.dao, this.metadataProviderOrNull);
        for (ImgAnalysisDatasetDTO dataset : datasets) {
            Map<String, ImgFeatureDefDTO> featureCodeToDefMap = lister.getFeatureCodeToDefMap(dataset);
            if (this.useAllFeatures) {
                this.featureCodes.addAll(featureCodeToDefMap.keySet());
            }
            this.assignIndicesToFeatures(featureCodeToDefMap);
            DatasetFeaturesBundle bundle = new DatasetFeaturesBundle();
            bundle.featureDefToValuesMap = lister.getFeatureValues(dataset);
            bundle.dataSet = dataset;
            bundle.plate = lister.getContainer(dataset);
            bundle.featureDefToVocabularyTerms = FeatureVectorLoader.createFeatureIdToVocabularyTermsMap(dataset, bundle.featureDefToValuesMap.keySet(), lister);
            this.bundles.add(bundle);
        }
    }

    private void assignIndicesToFeatures(Map<String, ImgFeatureDefDTO> featureCodeToDefMap) {
        for (String featureCode : this.featureCodes) {
            CodeAndLabel codeAndLabel;
            ImgFeatureDefDTO featureDefinition = featureCodeToDefMap.get(featureCode);
            if (featureDefinition == null || this.featureCodeLabelToIndexMap.containsKey(codeAndLabel = FeatureVectorLoader.asCodeAndLabel(featureDefinition))) continue;
            this.featureCodeLabelToIndexMap.put(codeAndLabel, new Integer(this.featureCodeLabelToIndexMap.size()));
        }
    }

    private static FeatureVocabularyTermsMap createFeatureIdToVocabularyTermsMap(ImgAnalysisDatasetDTO dataSet, Set<ImgFeatureDefDTO> datasetFeatureDefs, DatasetFeatureDefinitionCachedLister lister) {
        List<ImgFeatureVocabularyTermDTO> allTerms = lister.getFeatureVocabularyTerms(dataSet);
        return FeatureVocabularyTermsMap.createVocabularyTermsMap(allTerms, datasetFeatureDefs);
    }

    List<CodeAndLabel> getCodesAndLabels() {
        return Arrays.asList(this.getCodeAndLabelArray());
    }

    List<FeatureTableRow> createFeatureTableRows() {
        ArrayList<FeatureTableRow> rows = new ArrayList<FeatureTableRow>();
        for (DatasetFeaturesBundle bundle : this.bundles) {
            ImgContainerDTO plate = bundle.plate;
            SampleIdentifier identifier = this.tryGetSampleIdentifier(plate);
            int rowIndex = 1;
            while (rowIndex <= plate.getNumberOfRows()) {
                int colIndex = 1;
                while (colIndex <= plate.getNumberOfColumns()) {
                    FeatureTableRow row = this.createFeatureTableRow(bundle, identifier, null, new WellPosition(rowIndex, colIndex));
                    rows.add(row);
                    ++colIndex;
                }
                ++rowIndex;
            }
        }
        return rows;
    }

    private SampleIdentifier tryGetSampleIdentifier(ImgContainerDTO container) {
        if (this.metadataProviderOrNull != null) {
            return this.metadataProviderOrNull.tryGetSampleIdentifier(container.getPermId());
        }
        return null;
    }

    private List<FeatureVectorValues> createFeatureVectorValuesIfPossible(List<WellFeatureVectorReference> references) {
        HashMap<String, DatasetFeaturesBundle> bundleMap = FeatureVectorLoader.createBundleMap(this.bundles);
        ArrayList<FeatureVectorValues> featureVectors = new ArrayList<FeatureVectorValues>();
        for (WellFeatureVectorReference reference : references) {
            String referenceDataSetCode = reference.getDatasetCode();
            LinkedList<String> allCodes = new LinkedList<String>();
            allCodes.add(referenceDataSetCode);
            if (this.metadataProviderOrNull != null) {
                allCodes.addAll(this.metadataProviderOrNull.tryGetContainedDatasets(referenceDataSetCode));
            }
            for (String dataSetCode : allCodes) {
                DatasetFeaturesBundle bundle = (DatasetFeaturesBundle)bundleMap.get(dataSetCode);
                if (bundle == null) continue;
                FeatureVectorValues featureVector = this.createFeatureVector(bundle, reference.getWellLocation());
                featureVectors.add(featureVector);
            }
        }
        return featureVectors;
    }

    private List<FeatureTableRow> createFeatureTableRows(List<FeatureVectorDatasetWellReference> references) {
        HashMap<String, DatasetFeaturesBundle> bundleMap = FeatureVectorLoader.createBundleMap(this.bundles);
        ArrayList<FeatureTableRow> rows = new ArrayList<FeatureTableRow>();
        for (FeatureVectorDatasetWellReference reference : references) {
            String dataSetCode = reference.getDatasetCode();
            DatasetFeaturesBundle bundle = this.getDatasetFeaturesBundleOrDie(bundleMap, dataSetCode);
            ImgContainerDTO plate = bundle.plate;
            SampleIdentifier identifier = this.tryGetSampleIdentifier(plate);
            FeatureTableRow row = this.createFeatureTableRow(bundle, identifier, reference, reference.getWellPosition());
            rows.add(row);
        }
        return rows;
    }

    private DatasetFeaturesBundle getDatasetFeaturesBundleOrDie(Map<String, DatasetFeaturesBundle> bundleMap, String dataSetCode) {
        DatasetFeaturesBundle bundle = bundleMap.get(dataSetCode);
        if (bundle == null) {
            throw new IllegalStateException("Dataset has not been loaded: " + dataSetCode);
        }
        return bundle;
    }

    private static HashMap<String, DatasetFeaturesBundle> createBundleMap(List<DatasetFeaturesBundle> bundles) {
        HashMap<String, DatasetFeaturesBundle> map = new HashMap<String, DatasetFeaturesBundle>();
        for (DatasetFeaturesBundle bundle : bundles) {
            map.put(bundle.dataSet.getPermId(), bundle);
            if (bundle.dataSet.getDataSetContainerId() == null) continue;
            map.put(bundle.dataSet.getDataSetContainerId(), bundle);
        }
        return map;
    }

    private FeatureTableRow createFeatureTableRow(DatasetFeaturesBundle bundle, SampleIdentifier identifierOrNull, FeatureVectorDatasetWellReference reference, WellPosition wellPosition) {
        FeatureVectorValues featureVector = this.createFeatureVector(bundle, FeatureVectorLoader.convert(wellPosition));
        FeatureTableRow row = new FeatureTableRow(featureVector);
        row.setPlateIdentifier(identifierOrNull);
        row.setReference(reference);
        return row;
    }

    private static WellLocation convert(WellPosition wellPosition) {
        return new WellLocation(wellPosition.getWellRow(), wellPosition.getWellColumn());
    }

    private FeatureVectorValues createFeatureVector(DatasetFeaturesBundle bundle, WellLocation wellLocation) {
        String permId = bundle.dataSet.getPermId();
        FeatureValue[] valueArray = this.createFeatureValueArray(bundle.featureDefToValuesMap, bundle.featureDefToVocabularyTerms, wellLocation);
        return new FeatureVectorValues(permId, wellLocation, bundle.plate.getPermId(), this.getCodeAndLabelArray(), valueArray);
    }

    private CodeAndLabel[] getCodeAndLabelArray() {
        if (this.codesAndLabels != null) {
            return this.codesAndLabels;
        }
        this.codesAndLabels = new CodeAndLabel[this.featureCodeLabelToIndexMap.size()];
        Iterator<CodeAndLabel> iterator = this.featureCodeLabelToIndexMap.keySet().iterator();
        while (iterator.hasNext()) {
            CodeAndLabel codeAndLabel;
            this.codesAndLabels[this.featureCodeLabelToIndexMap.get((Object)codeAndLabel).intValue()] = codeAndLabel = iterator.next();
        }
        return this.codesAndLabels;
    }

    private FeatureValue[] createFeatureValueArray(Map<ImgFeatureDefDTO, List<ImgFeatureValuesDTO>> featureDefToValuesMap, FeatureVocabularyTermsMap featureDefToVocabularyTerms, WellLocation wellLocation) {
        FeatureValue[] valueArray = new FeatureValue[this.featureCodeLabelToIndexMap.size()];
        for (Map.Entry<ImgFeatureDefDTO, List<ImgFeatureValuesDTO>> entry : featureDefToValuesMap.entrySet()) {
            ImgFeatureDefDTO featureDefinition = entry.getKey();
            List<ImgFeatureValuesDTO> featureValueSets = entry.getValue();
            ImgFeatureValuesDTO featureValueDTO = featureValueSets.get(0);
            PlateFeatureValues featureValues = featureValueDTO.getValues();
            if (wellLocation.getRow() > featureValues.getGeometry().getNumberOfRows() || wellLocation.getColumn() > featureValues.getGeometry().getNumberOfColumns()) break;
            Integer index = this.featureCodeLabelToIndexMap.get(FeatureVectorLoader.asCodeAndLabel(featureDefinition));
            assert (index != null) : "No index for feature " + featureDefinition.getCode();
            float floatValue = featureValues.getForWellLocation(wellLocation.getRow(), wellLocation.getColumn());
            valueArray[index.intValue()] = FeatureVectorLoader.createFeatureValue(floatValue, featureDefinition, featureDefToVocabularyTerms);
        }
        this.fillEmptyValues(valueArray, featureDefToVocabularyTerms);
        return valueArray;
    }

    private void fillEmptyValues(FeatureValue[] valueArray, FeatureVocabularyTermsMap featureDefToVocabularyTerms) {
        for (CodeAndLabel featureName : this.featureCodeLabelToIndexMap.keySet()) {
            Integer index = this.featureCodeLabelToIndexMap.get(featureName);
            if (valueArray[index] != null) continue;
            FeatureValue emptyFeatureValue = featureDefToVocabularyTerms.hasVocabularyTerms(featureName.getCode()) ? FeatureValue.createEmptyVocabularyTerm() : FeatureValue.createEmptyFloat();
            valueArray[index.intValue()] = emptyFeatureValue;
        }
    }

    private static FeatureValue createFeatureValue(float floatValue, ImgFeatureDefDTO featureDefinition, FeatureVocabularyTermsMap featureDefToVocabularyTerms) {
        long featureDefId = featureDefinition.getId();
        if (featureDefToVocabularyTerms.hasVocabularyTerms(featureDefId)) {
            if (Float.isNaN(floatValue)) {
                return FeatureValue.createEmptyVocabularyTerm();
            }
            return featureDefToVocabularyTerms.getVocabularyTerm(featureDefId, (int)floatValue);
        }
        return FeatureValue.createFloat(floatValue);
    }

    private static CodeAndLabel asCodeAndLabel(ImgFeatureDefDTO featureDefinition) {
        return new CodeAndLabel(featureDefinition.getCode(), featureDefinition.getLabel());
    }

    private static class DatasetFeatureDefinitionCachedLister {
        private final GroupByMap<Long, ImgFeatureDefDTO> requestedFeatureDefinitionsMap;
        private final GroupByMap<Long, ImgFeatureVocabularyTermDTO> featureVocabularyTermsMap;
        private final GroupByMap<Long, ImgFeatureValuesDTO> featureValuesMap;
        private final TableMap<Long, ImgContainerDTO> containersByIdMap;

        public DatasetFeatureDefinitionCachedLister(List<ImgAnalysisDatasetDTO> datasets, Set<String> featureCodes, boolean useAllFeatures, IImagingReadonlyQueryDAO dao, IMetadataProvider provider) {
            this.containersByIdMap = DatasetFeatureDefinitionCachedLister.createContainerByIdMap(datasets, dao);
            long[] datasetIds = DatasetFeatureDefinitionCachedLister.extractIds(datasets);
            List<ImgFeatureDefDTO> requestedFeatureDefinitions = this.listRequestedFeatureDefinitions(datasetIds, featureCodes, useAllFeatures, dao);
            this.requestedFeatureDefinitionsMap = GroupByMap.create(requestedFeatureDefinitions, new IGroupKeyExtractor<Long, ImgFeatureDefDTO>(){

                @Override
                public Long getKey(ImgFeatureDefDTO featureDef) {
                    return featureDef.getDataSetId();
                }
            });
            List<ImgFeatureVocabularyTermDTO> featureVocabularyTerms = dao.listFeatureVocabularyTermsByDataSetId(datasetIds);
            this.featureVocabularyTermsMap = GroupByMap.create(featureVocabularyTerms, new IGroupKeyExtractor<Long, ImgFeatureVocabularyTermDTO>(){

                @Override
                public Long getKey(ImgFeatureVocabularyTermDTO featureVocabularyTerm) {
                    return featureVocabularyTerm.getDataSetId();
                }
            });
            List<ImgFeatureValuesDTO> requestedFeatureValues = dao.getFeatureValues(DatasetFeatureDefinitionCachedLister.extractIds(requestedFeatureDefinitions));
            this.featureValuesMap = GroupByMap.create(requestedFeatureValues, new IGroupKeyExtractor<Long, ImgFeatureValuesDTO>(){

                @Override
                public Long getKey(ImgFeatureValuesDTO featureVal) {
                    return featureVal.getFeatureDefId();
                }
            });
        }

        private static TableMap<Long, ImgContainerDTO> createContainerByIdMap(List<ImgAnalysisDatasetDTO> datasets, IImagingReadonlyQueryDAO dao) {
            List<ImgContainerDTO> containers = dao.listContainersByIds(DatasetFeatureDefinitionCachedLister.extractContainerIds(datasets));
            return new TableMap<Long, ImgContainerDTO>(containers, new IKeyExtractor<Long, ImgContainerDTO>(){

                @Override
                public Long getKey(ImgContainerDTO container) {
                    return container.getId();
                }
            });
        }

        private List<ImgFeatureDefDTO> listRequestedFeatureDefinitions(long[] datasetIds, Set<String> featureCodes, boolean useAllFeatures, IImagingReadonlyQueryDAO dao) {
            List<ImgFeatureDefDTO> allFeatureDefinitions = dao.listFeatureDefsByDataSetIds(datasetIds);
            List<ImgFeatureDefDTO> requestedFeatureDefinitions = DatasetFeatureDefinitionCachedLister.extractRequestedFeatureDefinitions(featureCodes, useAllFeatures, allFeatureDefinitions);
            return requestedFeatureDefinitions;
        }

        public ImgContainerDTO getContainer(ImgAnalysisDatasetDTO dataset) {
            return this.containersByIdMap.getOrDie(dataset.getContainerId());
        }

        public Map<String, ImgFeatureDefDTO> getFeatureCodeToDefMap(ImgAnalysisDatasetDTO dataset) {
            List<ImgFeatureDefDTO> featureDefinitions = this.getRequestedFeatureDefinitions(dataset);
            return DatasetFeatureDefinitionCachedLister.createCodeToDefMap(featureDefinitions);
        }

        private List<ImgFeatureDefDTO> getRequestedFeatureDefinitions(ImgAnalysisDatasetDTO dataset) {
            List<ImgFeatureDefDTO> def = this.requestedFeatureDefinitionsMap.tryGet(dataset.getId());
            return def == null ? Collections.emptyList() : def;
        }

        public List<ImgFeatureVocabularyTermDTO> getFeatureVocabularyTerms(ImgAnalysisDatasetDTO dataSet) {
            List<ImgFeatureVocabularyTermDTO> terms = this.featureVocabularyTermsMap.tryGet(dataSet.getId());
            if (terms == null) {
                return Collections.emptyList();
            }
            return terms;
        }

        public Map<ImgFeatureDefDTO, List<ImgFeatureValuesDTO>> getFeatureValues(ImgAnalysisDatasetDTO dataset) {
            List<ImgFeatureDefDTO> datasetFeatureDefinitions = this.getRequestedFeatureDefinitions(dataset);
            HashMap<ImgFeatureDefDTO, List<ImgFeatureValuesDTO>> defToValuesMap = new HashMap<ImgFeatureDefDTO, List<ImgFeatureValuesDTO>>();
            for (ImgFeatureDefDTO featureDef : datasetFeatureDefinitions) {
                List<ImgFeatureValuesDTO> values = this.featureValuesMap.getOrDie(featureDef.getId());
                defToValuesMap.put(featureDef, values);
            }
            return defToValuesMap;
        }

        private static List<ImgFeatureDefDTO> extractRequestedFeatureDefinitions(Set<String> featureCodes, boolean useAllFeatures, List<ImgFeatureDefDTO> allFeatureDefinitions) {
            if (useAllFeatures) {
                return allFeatureDefinitions;
            }
            return DatasetFeatureDefinitionCachedLister.filterByCode(allFeatureDefinitions, featureCodes);
        }

        private static List<ImgFeatureDefDTO> filterByCode(List<ImgFeatureDefDTO> allFeatureDefinitions, Set<String> featureCodes) {
            ArrayList<ImgFeatureDefDTO> result = new ArrayList<ImgFeatureDefDTO>();
            for (ImgFeatureDefDTO featureDef : allFeatureDefinitions) {
                if (!featureCodes.contains(featureDef.getCode())) continue;
                result.add(featureDef);
            }
            return result;
        }

        private static long[] extractContainerIds(List<ImgAnalysisDatasetDTO> datasets) {
            long[] ids = new long[datasets.size()];
            int i = 0;
            for (ImgAnalysisDatasetDTO dataset : datasets) {
                ids[i++] = dataset.getContainerId();
            }
            return ids;
        }

        private static long[] extractIds(List<? extends AbstractImgIdentifiable> identifiables) {
            long[] ids = new long[identifiables.size()];
            int i = 0;
            for (AbstractImgIdentifiable abstractImgIdentifiable : identifiables) {
                ids[i++] = abstractImgIdentifiable.getId();
            }
            return ids;
        }

        private static Map<String, ImgFeatureDefDTO> createCodeToDefMap(List<ImgFeatureDefDTO> featureDefinitions) {
            LinkedHashMap<String, ImgFeatureDefDTO> featureCodeToDefMap = new LinkedHashMap<String, ImgFeatureDefDTO>();
            for (ImgFeatureDefDTO def : featureDefinitions) {
                featureCodeToDefMap.put(def.getCode(), def);
            }
            return featureCodeToDefMap;
        }
    }

    private static final class DatasetFeaturesBundle {
        private ImgAnalysisDatasetDTO dataSet;
        private String datasetContainerCode;
        private Map<ImgFeatureDefDTO, List<ImgFeatureValuesDTO>> featureDefToValuesMap;
        private FeatureVocabularyTermsMap featureDefToVocabularyTerms;
        private ImgContainerDTO plate;

        private DatasetFeaturesBundle() {
        }
    }

    public static interface IMetadataProvider {
        public void getSampleIdentifiers(List<String> var1);

        public SampleIdentifier tryGetSampleIdentifier(String var1);

        public List<String> tryGetContainedDatasets(String var1);
    }

    public static class WellFeatureCollection<T extends FeatureVectorValues> {
        private final List<T> features;
        private final List<CodeAndLabel> featureNames;

        public WellFeatureCollection(List<T> features, List<CodeAndLabel> featureNames) {
            this.features = features;
            this.featureNames = featureNames;
        }

        public List<T> getFeatures() {
            return this.features;
        }

        public List<CodeAndLabel> getFeatureCodesAndLabels() {
            return this.featureNames;
        }

        public List<String> getFeatureCodes() {
            ArrayList<String> codes = new ArrayList<String>();
            for (CodeAndLabel codeAndTitle : this.featureNames) {
                codes.add(codeAndTitle.getCode());
            }
            return codes;
        }

        public List<String> getFeatureLabels() {
            ArrayList<String> labels = new ArrayList<String>();
            for (CodeAndLabel codeAndTitle : this.featureNames) {
                labels.add(codeAndTitle.getLabel());
            }
            return labels;
        }
    }
}

