/*
 * Decompiled with CFR 0.152.
 */
package net.lemnik.eodsql.spi.util;

import java.lang.reflect.InvocationTargetException;

interface MethodParameterTool {
    public Object getParameter(Object ... var1);

    public Class getParameterType();

    public static class Chained
    implements MethodParameterTool {
        private final MethodParameterTool from;
        private final MethodParameterTool to;

        public Chained(MethodParameterTool from, MethodParameterTool to) {
            this.from = from;
            this.to = to;
        }

        public Object getParameter(Object ... params) {
            return this.to.getParameter(this.from.getParameter(params));
        }

        public Class getParameterType() {
            return this.to.getParameterType();
        }
    }

    public static class Method
    implements MethodParameterTool {
        private final int paramIndex;
        private final java.lang.reflect.Method method;

        public Method(int paramIndex, java.lang.reflect.Method method) {
            this.paramIndex = paramIndex;
            this.method = method;
        }

        public Object getParameter(Object ... params) {
            try {
                return this.method.invoke(params[this.paramIndex], new Object[0]);
            }
            catch (IllegalArgumentException ex) {
                throw new RuntimeException(ex);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
            catch (InvocationTargetException ex) {
                throw new RuntimeException(ex);
            }
        }

        public Class getParameterType() {
            return this.method.getReturnType();
        }
    }

    public static class Field
    implements MethodParameterTool {
        private final int paramIndex;
        private final java.lang.reflect.Field field;

        public Field(int paramIndex, java.lang.reflect.Field field) {
            this.paramIndex = paramIndex;
            this.field = field;
        }

        public Object getParameter(Object ... params) {
            try {
                return this.field.get(params[this.paramIndex]);
            }
            catch (IllegalArgumentException argumentException) {
                throw new RuntimeException(argumentException);
            }
            catch (IllegalAccessException accessException) {
                throw new RuntimeException(accessException);
            }
        }

        public Class getParameterType() {
            return this.field.getType();
        }
    }

    public static class Parameter
    implements MethodParameterTool {
        private final int paramIndex;
        private final Class type;

        public Parameter(int paramIndex, Class type) {
            this.paramIndex = paramIndex;
            this.type = type;
        }

        public Object getParameter(Object ... params) {
            return params[this.paramIndex];
        }

        public Class getParameterType() {
            return this.type;
        }
    }
}

