/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cina.client.util.v1.impl;

import ch.systemsx.cisd.cina.client.util.v1.impl.AbstractCinaFacadeState;
import ch.systemsx.cisd.common.exceptions.AuthorizationFailureException;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.dss.client.api.v1.IDataSetDss;
import ch.systemsx.cisd.openbis.dss.client.api.v1.IDssComponent;
import ch.systemsx.cisd.openbis.generic.shared.IServiceForDataStoreServer;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.IGeneralInformationService;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSet;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.SearchCriteria;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.SpaceWithProjectsAndRoleAssignments;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType;
import java.util.ArrayList;
import java.util.List;

class AuthenticatedState
extends AbstractCinaFacadeState {
    private final String sessionToken;
    private final IServiceForDataStoreServer openbisService;
    private final IDssComponent dssComponent;
    private final int generalInformationServiceMinorVersion;

    AuthenticatedState(IGeneralInformationService service, IServiceForDataStoreServer openbisService, IDssComponent dssComponent, String sessionToken) {
        super(service);
        this.sessionToken = sessionToken;
        this.openbisService = openbisService;
        this.dssComponent = dssComponent;
        this.generalInformationServiceMinorVersion = service.getMinorVersion();
    }

    @Override
    void login(String user, String password) throws AuthorizationFailureException {
        throw new IllegalStateException("Already logged in.");
    }

    @Override
    public void logout() {
        this.service.logout(this.getSessionToken());
    }

    @Override
    public List<Sample> searchForSamples(SearchCriteria searchCriteria) throws IllegalStateException, EnvironmentFailureException {
        int minorVersion = this.generalInformationServiceMinorVersion;
        if (minorVersion < 1) {
            throw new EnvironmentFailureException("Server does not support this feature.");
        }
        return this.service.searchForSamples(this.sessionToken, searchCriteria);
    }

    @Override
    public String getSessionToken() {
        return this.sessionToken;
    }

    @Override
    public String generateSampleCode(String sampleTypeCode) throws IllegalStateException, EnvironmentFailureException {
        SampleType replicaSampleType = this.openbisService.getSampleType(this.sessionToken, sampleTypeCode);
        long sampleCodeSuffix = this.openbisService.drawANewUniqueID(this.sessionToken);
        String sampleCode = String.format("%s%d", replicaSampleType.getGeneratedCodePrefix(), sampleCodeSuffix);
        return sampleCode;
    }

    @Override
    public List<Experiment> listVisibleExperiments(String experimentType) throws IllegalStateException, EnvironmentFailureException {
        int minorVersion = this.generalInformationServiceMinorVersion;
        if (minorVersion < 2) {
            throw new EnvironmentFailureException("Server does not support this feature.");
        }
        List spaces = this.service.listSpacesWithProjectsAndRoleAssignments(this.sessionToken, null);
        ArrayList projects = new ArrayList();
        for (SpaceWithProjectsAndRoleAssignments space : spaces) {
            projects.addAll(space.getProjects());
        }
        return this.service.listExperiments(this.sessionToken, projects, experimentType);
    }

    @Override
    public List<DataSet> listDataSets(List<Sample> samples) throws IllegalStateException, EnvironmentFailureException {
        int minorVersion = this.generalInformationServiceMinorVersion;
        if (minorVersion < 1) {
            throw new EnvironmentFailureException("Server does not support this feature.");
        }
        return this.service.listDataSets(this.sessionToken, samples);
    }

    @Override
    public IDataSetDss getDataSet(String dataSetCode) throws IllegalStateException, EnvironmentFailureException, UserFailureException {
        return this.dssComponent.getDataSet(dataSetCode);
    }

    @Override
    public List<DataSet> listDataSetsForSample(Sample sample, boolean areOnlyDirectlyConnectedIncluded) throws IllegalStateException, EnvironmentFailureException, UserFailureException {
        int minorVersion = this.generalInformationServiceMinorVersion;
        if (minorVersion < 3) {
            throw new EnvironmentFailureException("Server does not support this feature.");
        }
        return this.service.listDataSetsForSample(this.sessionToken, sample, areOnlyDirectlyConnectedIncluded);
    }
}

